/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6363")
public class WebViewsFileAccessCheck
extends AbstractMethodDetection {
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofSubTypes(new String[]{"android.webkit.WebSettings"}).names(new String[]{"setAllowFileAccess", "setAllowFileAccessFromFileURLs", "setAllowContentAccess", "setAllowUniversalAccessFromFileURLs"}).addParametersMatcher(new String[]{"boolean"}).build();
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree argument = (ExpressionTree)mit.arguments().get(0);
        if (Boolean.TRUE.equals(ExpressionUtils.resolveAsConstant((ExpressionTree)argument))) {
            this.reportIssue((Tree)argument, "Make sure that enabling file access is safe here.");
        }
    }
}

