/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6818")
public class AutowiredOnMultipleConstructorsCheck
extends IssuableSubscriptionVisitor {
    private static final String AUTOWIRED_ANNOTATION = "org.springframework.beans.factory.annotation.Autowired";

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        List<MethodTree> constructors = classTree.members().stream().filter(m -> m.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})).map(m -> (MethodTree)m).toList();
        if (constructors.size() > 1) {
            boolean isAutowiredAlreadyFound = false;
            for (MethodTree constructor : constructors) {
                boolean isAutowired = this.checkConstructor(constructor, isAutowiredAlreadyFound);
                if (!isAutowired) continue;
                isAutowiredAlreadyFound = true;
            }
        }
    }

    private boolean checkConstructor(MethodTree methodTree, boolean isAutowiredAlreadyFound) {
        boolean isAutowired = AutowiredOnMultipleConstructorsCheck.isAutowired((Symbol)methodTree.symbol());
        if (isAutowiredAlreadyFound && isAutowired) {
            Optional<AnnotationTree> autowiredAnnotation = methodTree.modifiers().annotations().stream().filter(a -> a.annotationType().symbolType().is(AUTOWIRED_ANNOTATION)).findFirst();
            autowiredAnnotation.ifPresent(annotationTree -> this.reportIssue((Tree)annotationTree, "Remove this \"@Autowired\" annotation."));
        }
        return isAutowired;
    }

    private static boolean isAutowired(Symbol s) {
        if (s.metadata().isAnnotatedWith(AUTOWIRED_ANNOTATION)) {
            List annotationValues = s.metadata().valuesForAnnotation(AUTOWIRED_ANNOTATION);
            return annotationValues.isEmpty() || annotationValues.stream().anyMatch(a -> a.value().equals(true));
        }
        return false;
    }
}

