/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.SpringUtils;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S7190")
public class BeforeAndAfterTransactionContractCheck
extends IssuableSubscriptionVisitor {
    private static final String BEFORE_TRANSACTION_FQN = "org.springframework.test.context.transaction.BeforeTransaction";
    private static final String AFTER_TRANSACTION_FQN = "org.springframework.test.context.transaction.AfterTransaction";
    private static final List<String> TRANSACTION_ANNOTATIONS = List.of("org.springframework.test.context.transaction.BeforeTransaction", "org.springframework.test.context.transaction.AfterTransaction");
    private static final String TEST_INFO_FQN = "org.junit.jupiter.api.TestInfo";
    private static final String RETURN_VOID_MESSAGE = "%s method should return void.";
    private static final String NO_PARAMETERS_MESSAGE = "%s method should not have parameters.";

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTreeImpl methodTree = (MethodTreeImpl)tree;
        if (methodTree.symbol().metadata().isAnnotatedWith(BEFORE_TRANSACTION_FQN)) {
            this.checkReturnType(methodTree, "@BeforeTransaction");
            this.checkParameters(methodTree, "@BeforeTransaction");
        } else if (methodTree.symbol().metadata().isAnnotatedWith(AFTER_TRANSACTION_FQN)) {
            this.checkReturnType(methodTree, "@AfterTransaction");
            this.checkParameters(methodTree, "@AfterTransaction");
        }
    }

    private void checkReturnType(MethodTreeImpl methodTree, String annotationName) {
        if (!methodTree.returnType().symbolType().isVoid()) {
            String message = String.format(RETURN_VOID_MESSAGE, annotationName);
            this.reportIssue((Tree)methodTree.returnType(), message, BeforeAndAfterTransactionContractCheck.getSecondaryLocations(methodTree), null);
        }
    }

    private void checkParameters(MethodTreeImpl methodTree, String annotationName) {
        List parameters = methodTree.parameters();
        if (!parameters.isEmpty() && parameters.stream().anyMatch(parameter -> !BeforeAndAfterTransactionContractCheck.isParameterAllowed(parameter))) {
            String message = String.format(NO_PARAMETERS_MESSAGE, annotationName);
            VariableTree first = (VariableTree)methodTree.parameters().get(0);
            VariableTree last = (VariableTree)methodTree.parameters().get(methodTree.parameters().size() - 1);
            this.reportIssue((Tree)first, (Tree)last, message, BeforeAndAfterTransactionContractCheck.getSecondaryLocations(methodTree), null);
        }
    }

    private static boolean isParameterAllowed(VariableTree parameter) {
        Symbol parameterSymbol = parameter.symbol();
        if (parameterSymbol.type().is(TEST_INFO_FQN)) {
            return true;
        }
        return SpringUtils.isAutowired(parameterSymbol);
    }

    private static List<JavaFileScannerContext.Location> getSecondaryLocations(MethodTreeImpl methodTree) {
        return methodTree.modifiers().annotations().stream().filter(annotation -> TRANSACTION_ANNOTATIONS.contains(annotation.symbolType().fullyQualifiedName())).map(annotation -> new JavaFileScannerContext.Location("Annotation", (Tree)annotation)).toList();
    }
}

