/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S7183")
public class InitBinderMethodsMustBeVoidCheck
extends IssuableSubscriptionVisitor {
    private static final String INIT_BINDER = "org.springframework.web.bind.annotation.InitBinder";
    private static final String ISSUE_MESSAGE = "Methods annotated with @InitBinder must return void.";

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree method = (MethodTree)tree;
        TypeTree returnType = method.returnType();
        if (returnType.symbolType().isVoid()) {
            return;
        }
        boolean hasInitBinder = method.modifiers().annotations().stream().anyMatch(ann -> ann.annotationType().symbolType().is(INIT_BINDER));
        if (hasInitBinder) {
            this.reportIssue((Tree)method.simpleName(), ISSUE_MESSAGE);
        }
    }
}

