/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S7184")
public class ScheduledOnlyOnNoArgMethodCheck
extends IssuableSubscriptionVisitor {
    public static final String SCHEDULED_FQN = "org.springframework.scheduling.annotation.Scheduled";

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        List<AnnotationTree> scheduledAnnotations;
        MethodTree methodTree = (MethodTree)tree;
        if (ScheduledOnlyOnNoArgMethodCheck.hasParameters(methodTree) && !(scheduledAnnotations = ScheduledOnlyOnNoArgMethodCheck.getScheduledAnnotations(methodTree)).isEmpty()) {
            List<JavaFileScannerContext.Location> secondaryLocations = scheduledAnnotations.stream().map(annotation -> new JavaFileScannerContext.Location("Triggered by this annotation", (Tree)annotation.annotationType())).toList();
            this.reportIssue((Tree)methodTree.simpleName(), "\"@Scheduled\" annotation should only be applied to no-arg methods", secondaryLocations, null);
        }
    }

    private static boolean hasParameters(MethodTree methodTree) {
        return !methodTree.parameters().isEmpty();
    }

    private static List<AnnotationTree> getScheduledAnnotations(MethodTree methodTree) {
        return methodTree.modifiers().annotations().stream().filter(annotation -> annotation.annotationType().symbolType().is(SCHEDULED_FQN)).toList();
    }
}

