/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.SpringUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3749")
public class SpringComponentWithNonAutowiredMembersCheck
extends IssuableSubscriptionVisitor {
    @RuleProperty(key="customInjectionAnnotations", description="comma-separated list of FQDN annotation names to consider as valid", defaultValue="")
    public String customInjectionAnnotations = "";
    private static final List<String> SPRING_INJECTION_ANNOTATION = Arrays.asList("org.springframework.beans.factory.annotation.Autowired", "javax.inject.Inject", "jakarta.inject.Inject", "javax.annotation.Resource", "jakarta.annotation.Resource", "javax.persistence.PersistenceContext", "jakarta.persistence.PersistenceContext", "org.springframework.beans.factory.annotation.Value");
    private static final List<String> SPRING_SINGLETON_ANNOTATION = Arrays.asList("org.springframework.stereotype.Controller", "org.springframework.web.bind.annotation.RestController", "org.springframework.stereotype.Service", "org.springframework.stereotype.Component", "org.springframework.stereotype.Repository");

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree clazzTree = (ClassTree)tree;
        Set<Symbol> symbolsUsedInConstructors = this.symbolsUsedInConstructors(clazzTree);
        if (SpringComponentWithNonAutowiredMembersCheck.isSpringSingletonComponent(clazzTree.symbol().metadata())) {
            clazzTree.members().stream().filter(v -> v.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(VariableTree.class::cast).filter(v -> !v.symbol().isStatic()).filter(v -> !SpringComponentWithNonAutowiredMembersCheck.isSpringInjectionAnnotated(v.symbol().metadata())).filter(v -> !this.isCustomInjectionAnnotated(v.symbol().metadata())).filter(v -> !symbolsUsedInConstructors.contains(v.symbol())).forEach(v -> this.reportIssue((Tree)v.simpleName(), "Annotate this member with \"@Autowired\", \"@Resource\", \"@Inject\", or \"@Value\", or remove it."));
        }
    }

    private static boolean isSpringInjectionAnnotated(SymbolMetadata metadata) {
        return SPRING_INJECTION_ANNOTATION.stream().anyMatch(arg_0 -> ((SymbolMetadata)metadata).isAnnotatedWith(arg_0));
    }

    private boolean isCustomInjectionAnnotated(SymbolMetadata metadata) {
        return Arrays.stream(this.customInjectionAnnotations.split(",")).map(String::trim).anyMatch(arg_0 -> ((SymbolMetadata)metadata).isAnnotatedWith(arg_0));
    }

    private static boolean isSpringSingletonComponent(SymbolMetadata clazzMeta) {
        return SPRING_SINGLETON_ANNOTATION.stream().anyMatch(arg_0 -> ((SymbolMetadata)clazzMeta).isAnnotatedWith(arg_0)) && !SpringComponentWithNonAutowiredMembersCheck.isUsingConfigurationProperties(clazzMeta) && SpringUtils.isScopeSingleton(clazzMeta);
    }

    private static boolean isUsingConfigurationProperties(SymbolMetadata classMeta) {
        return classMeta.isAnnotatedWith("org.springframework.boot.context.properties.ConfigurationProperties");
    }

    private Set<Symbol> symbolsUsedInConstructors(ClassTree clazzTree) {
        List<Symbol.MethodSymbol> constructors = SpringComponentWithNonAutowiredMembersCheck.constructors(clazzTree);
        return constructors.stream().filter(ctor -> this.isAutowired(constructors, (Symbol.MethodSymbol)ctor)).map(Symbol.MethodSymbol::declaration).flatMap(ctorTree -> SpringComponentWithNonAutowiredMembersCheck.symbolsUsedInMethod(ctorTree.symbol()).stream()).collect(Collectors.toSet());
    }

    private boolean isAutowired(List<Symbol.MethodSymbol> constructors, Symbol.MethodSymbol ctor) {
        return SpringComponentWithNonAutowiredMembersCheck.isSpringInjectionAnnotated(ctor.metadata()) || this.isCustomInjectionAnnotated(ctor.metadata()) || constructors.size() == 1;
    }

    private static Set<Symbol> symbolsUsedInMethod(Symbol.MethodSymbol methodSymbol) {
        IdentifierCollector identifierCollector = new IdentifierCollector();
        methodSymbol.declaration().accept((TreeVisitor)identifierCollector);
        return identifierCollector.identifiers;
    }

    private static List<Symbol.MethodSymbol> constructors(ClassTree clazzTree) {
        return clazzTree.symbol().memberSymbols().stream().filter(Symbol::isMethodSymbol).map(s -> (Symbol.MethodSymbol)s).filter(m -> "<init>".equals(m.name())).filter(m -> m.declaration() != null).toList();
    }

    private static class IdentifierCollector
    extends BaseTreeVisitor {
        Set<Symbol> identifiers = new HashSet<Symbol>();

        private IdentifierCollector() {
        }

        public void visitIdentifier(IdentifierTree tree) {
            this.identifiers.add(tree.symbol());
        }
    }
}

