/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S7186")
public class UsePageableParameterForPagedQueryCheck
extends IssuableSubscriptionVisitor {
    private static final String ISSUE_MESSAGE = "Add a \"Pageable\" parameter to this method to support pagination.";
    private static final String SPRING_REPOSITORY_FQN = "org.springframework.data.repository.Repository";
    private static final String SPRING_PAGE_FQN = "org.springframework.data.domain.Page";
    private static final String SPRING_SLICE_FQN = "org.springframework.data.domain.Slice";
    private static final String SPRING_PAGEABLE_FQN = "org.springframework.data.domain.Pageable";

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTreeImpl methodTree = (MethodTreeImpl)tree;
        Symbol.TypeSymbol enclosingClass = methodTree.symbol().enclosingClass();
        if (!enclosingClass.isInterface()) {
            return;
        }
        if (UsePageableParameterForPagedQueryCheck.isPageableMethod(methodTree, enclosingClass.type()) && !UsePageableParameterForPagedQueryCheck.hasPageableParameter(methodTree)) {
            this.reportIssue((Tree)methodTree, ISSUE_MESSAGE);
        }
    }

    private static boolean hasPageableParameter(MethodTreeImpl method) {
        return method.parameters().stream().map(param -> param.symbol().type()).anyMatch(type -> UsePageableParameterForPagedQueryCheck.isTypeOrDescendantOf(type, SPRING_PAGEABLE_FQN));
    }

    private static boolean isPageableMethod(MethodTreeImpl method, Type enclosingClassType) {
        return UsePageableParameterForPagedQueryCheck.returnsPageOrSlice(method) && UsePageableParameterForPagedQueryCheck.isTypeOrDescendantOf(enclosingClassType, SPRING_REPOSITORY_FQN);
    }

    private static boolean returnsPageOrSlice(MethodTreeImpl method) {
        TypeTree returnType = method.returnType();
        return returnType.symbolType().is(SPRING_PAGE_FQN) || returnType.symbolType().is(SPRING_SLICE_FQN);
    }

    private static boolean isTypeOrDescendantOf(Type type, String fullyQualifiedName) {
        if (type.is(fullyQualifiedName)) {
            return true;
        }
        for (Type superType : type.symbol().superTypes()) {
            if (!UsePageableParameterForPagedQueryCheck.isTypeOrDescendantOf(superType, fullyQualifiedName)) continue;
            return true;
        }
        return false;
    }
}

