/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public abstract class AbstractJUnit5NotCompliantModifierChecker
extends IssuableSubscriptionVisitor {
    protected static final String WRONG_MODIFIER_ISSUE_MESSAGE = "Remove this '%s' modifier.";

    protected abstract boolean isNonCompliantModifier(Modifier var1, ModifierScope var2);

    protected abstract void raiseIssueOnNonCompliantReturnType(MethodTree var1);

    protected void raiseIssueOnNonCompliantModifier(ModifierKeywordTree modifier) {
        QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)modifier).withMessage(WRONG_MODIFIER_ISSUE_MESSAGE, new Object[]{modifier.keyword().text()}).withQuickFix(() -> JavaQuickFix.newQuickFix((String)"Remove \"%s\" modifier", (Object[])new Object[]{modifier.keyword().text()}).addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)modifier, (boolean)true, (Tree)QuickFixHelper.nextToken((Tree)modifier), (boolean)false))}).build()).report();
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        boolean classHasJunit5InstanceMethods;
        ClassTree classTree = (ClassTree)tree;
        if (classTree.symbol().isAbstract()) {
            return;
        }
        ArrayList<MethodTree> junit5ClassMethods = new ArrayList<MethodTree>();
        ArrayList<MethodTree> junit5InstanceMethods = new ArrayList<MethodTree>();
        ArrayList<MethodTree> nonJunit5Methods = new ArrayList<MethodTree>();
        classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(MethodTree.class::cast).forEach(method -> {
            if (UnitTestUtils.hasJUnit5TestAnnotation(method) || UnitTestUtils.hasJUnit5InstanceLifecycleAnnotation(method)) {
                if (AbstractJUnit5NotCompliantModifierChecker.isNotOverriding(method)) {
                    junit5InstanceMethods.add((MethodTree)method);
                }
            } else if (UnitTestUtils.hasJUnit5ClassLifecycleAnnotation(method)) {
                if (AbstractJUnit5NotCompliantModifierChecker.isNotOverriding(method)) {
                    junit5ClassMethods.add((MethodTree)method);
                }
            } else {
                nonJunit5Methods.add((MethodTree)method);
            }
        });
        this.raiseIssueOnMethods(junit5ClassMethods, ModifierScope.CLASS_METHOD);
        this.raiseIssueOnMethods(junit5InstanceMethods, ModifierScope.INSTANCE_METHOD);
        boolean bl = classHasJunit5InstanceMethods = !junit5InstanceMethods.isEmpty();
        if (classHasJunit5InstanceMethods) {
            this.raiseIssueOnClass(nonJunit5Methods, classTree);
        }
    }

    private void raiseIssueOnMethods(List<MethodTree> junit5ClassMethods, ModifierScope classMethod) {
        for (MethodTree junit5ClassMethod : junit5ClassMethods) {
            this.raiseIssueOnNotCompliantModifiers(junit5ClassMethod.modifiers(), classMethod);
            this.raiseIssueOnNonCompliantReturnType(junit5ClassMethod);
        }
    }

    private void raiseIssueOnClass(List<MethodTree> nonJunit5Methods, ClassTree classTree) {
        boolean hasPublicStaticMethods = nonJunit5Methods.stream().map(MethodTree::modifiers).anyMatch(AbstractJUnit5NotCompliantModifierChecker::isPublicStatic);
        boolean hasPublicStaticFields = classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(VariableTree.class::cast).map(VariableTree::modifiers).anyMatch(AbstractJUnit5NotCompliantModifierChecker::isPublicStatic);
        if (hasPublicStaticMethods || hasPublicStaticFields) {
            return;
        }
        this.raiseIssueOnNotCompliantModifiers(classTree.modifiers(), ModifierScope.CLASS);
    }

    private static boolean isPublicStatic(ModifiersTree modifiers) {
        return ModifiersUtils.hasAll((ModifiersTree)modifiers, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
    }

    private void raiseIssueOnNotCompliantModifiers(ModifiersTree modifierTree, ModifierScope modifierScope) {
        modifierTree.modifiers().stream().filter(modifier -> this.isNonCompliantModifier(modifier.modifier(), modifierScope)).findFirst().ifPresent(this::raiseIssueOnNonCompliantModifier);
    }

    private static boolean isNotOverriding(MethodTree tree) {
        return Boolean.FALSE.equals(tree.isOverriding());
    }

    public static enum ModifierScope {
        CLASS,
        CLASS_METHOD,
        INSTANCE_METHOD;

    }
}

