/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.checks.tests.ActualExpectedInPredicateQuickFix;
import org.sonar.java.checks.tests.ActualExpectedInSubjectQuickFix;
import org.sonar.java.checks.tests.AssertJChainSimplificationCheck;
import org.sonar.java.checks.tests.AssertJChainSimplificationHelper;
import org.sonar.java.checks.tests.AssertJChainSimplificationQuickFix;
import org.sonar.java.checks.tests.ContextFreeQuickFix;
import org.sonar.java.checks.tests.NoQuickFix;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonarsource.analyzer.commons.collections.MapBuilder;

public class AssertJChainSimplificationIndex {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_UTIL_MAP = "java.util.Map";
    private static final String JAVA_UTIL_COLLECTION = "java.util.Collection";
    private static final String JAVA_IO_FILE = "java.io.File";
    private static final String JAVA_NIO_FILE_PATH = "java.nio.file.Path";
    private static final String JAVA_UTIL_OPTIONAL = "java.util.Optional";
    private static final String CONTAINS = "contains";
    private static final String CONTAINS_KEY = "containsKey";
    private static final String CONTAINS_VALUE = "containsValue";
    private static final String DOES_NOT_CONTAIN = "doesNotContain";
    private static final String DOES_NOT_START_WITH = "doesNotStartWith";
    private static final String HAS_SIZE = "hasSize";
    private static final String IS_BLANK = "isBlank";
    private static final String IS_EMPTY = "isEmpty";
    private static final String IS_EQUAL_TO = "isEqualTo";
    private static final String IS_EQUAL_TO_IGNORING_CASE = "isEqualToIgnoringCase";
    private static final String IS_FALSE = "isFalse";
    private static final String IS_GREATER_THAN = "isGreaterThan";
    private static final String IS_GREATER_THAN_OR_EQUAL_TO = "isGreaterThanOrEqualTo";
    private static final String IS_LESS_THAN = "isLessThan";
    private static final String IS_LESS_THAN_OR_EQUAL_TO = "isLessThanOrEqualTo";
    private static final String IS_NEGATIVE = "isNegative";
    private static final String IS_NOT_BLANK = "isNotBlank";
    private static final String IS_NOT_EMPTY = "isNotEmpty";
    private static final String IS_NOT_EQUAL_TO = "isNotEqualTo";
    private static final String IS_NOT_EQUAL_TO_IGNORING_CASE = "isNotEqualToIgnoringCase";
    private static final String IS_NOT_NEGATIVE = "isNotNegative";
    private static final String IS_NOT_NULL = "isNotNull";
    private static final String IS_NOT_POSITIVE = "isNotPositive";
    private static final String IS_NOT_PRESENT = "isNotPresent";
    private static final String IS_NOT_ZERO = "isNotZero";
    private static final String IS_POSITIVE = "isPositive";
    private static final String IS_PRESENT = "isPresent";
    private static final String IS_SAME_AS = "isSameAs";
    private static final String IS_TRUE = "isTrue";
    private static final String IS_ZERO = "isZero";
    private static final String IS_NULL = "isNull";
    private static final String STARTS_WITH = "startsWith";
    private static final String ENDS_WITH = "endsWith";
    private static final String HAS_SAME_SIZE_AS = "hasSameSizeAs";
    private static final String LENGTH = "length";
    private static final WithContextSimplification OPTIONAL_PRESENT_REPLACEMENT = WithContextSimplification.msgWithActual("isPresent");
    private static final WithContextSimplification OPTIONAL_EMPTY_REPLACEMENT = new WithContextSimplification(String.format("assertThat(actual).%s() or assertThat(actual).%s()", "isNotPresent", "isEmpty"));
    static final Map<String, List<AssertJChainSimplificationCheck.SimplifierWithoutContext>> CONTEXT_FREE_SIMPLIFIERS = MapBuilder.newMap().put((Object)"hasSize", Collections.singletonList(PredicateSimplifierWithoutContext.withSingleArg(LiteralUtils::isZero, "isEmpty()"))).put((Object)"isEqualTo", Collections.singletonList(PredicateSimplifierWithoutContext.withSingleArg(ExpressionUtils::isNullLiteral, "isNull()"))).put((Object)"isNotEqualTo", Collections.singletonList(PredicateSimplifierWithoutContext.withSingleArg(subject -> ExpressionUtils.isNullLiteral((ExpressionTree)subject) && !UnitTestUtils.isInUnitTestRelatedToObjectMethods(subject), "isNotNull()"))).build();
    static final Map<String, List<AssertJChainSimplificationCheck.SimplifierWithContext>> SIMPLIFIERS_WITH_CONTEXT = MapBuilder.newMap().put((Object)"isEqualTo", Arrays.asList(PredicateSimplifierWithContext.withSubjectArgumentCondition(LiteralUtils::isTrue, AssertJChainSimplificationIndex::isNotObject, "isTrue()"), PredicateSimplifierWithContext.withSubjectArgumentCondition(LiteralUtils::isFalse, AssertJChainSimplificationIndex::isNotObject, "isFalse()"), PredicateSimplifierWithContext.withSubjectArgumentCondition(LiteralUtils::isEmptyString, AssertJChainSimplificationIndex::isNotObject, "isEmpty()"), PredicateSimplifierWithContext.withSubjectArgumentCondition(AssertJChainSimplificationIndex::isZeroIntOrLong, AssertJChainSimplificationIndex::isStringLength, WithContextSimplification.msgWithActual("isEmpty")), PredicateSimplifierWithContext.withSubjectArgumentCondition(AssertJChainSimplificationIndex::isZeroIntOrLong, AssertJChainSimplificationIndex::isCollectionSize, WithContextSimplification.msgWithActual("isEmpty")), PredicateSimplifierWithContext.withSubjectArgumentCondition(AssertJChainSimplificationIndex::isZeroIntOrLong, AssertJChainSimplificationIndex::isArrayLength, WithContextSimplification.msgWithActual("isEmpty")), PredicateSimplifierWithContext.withSubjectArgumentCondition(AssertJChainSimplificationIndex::isZeroIntOrLong, AssertJChainSimplificationIndex::isNotObject, "isZero()"), PredicateSimplifierWithContext.methodCallInSubject(Matchers.TO_STRING, WithContextSimplification.msgWithActualCustom("hasToString", "expectedString")), PredicateSimplifierWithContext.methodCallInSubject(predicateArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(predicateArg, Matchers.HASH_CODE), Matchers.HASH_CODE, WithContextSimplification.msgWithActualExpected("hasSameHashCodeAs")), AssertJChainSimplificationIndex.compareToSimplifier(LiteralUtils::isZero, "isEqualByComparingTo"), PredicateSimplifierWithContext.methodCallInSubject(LiteralUtils::isZero, Matchers.COMPARE_TO_IGNORE_CASE, WithContextSimplification.msgWithActualExpectedInSubject("isEqualToIgnoringCase")), AssertJChainSimplificationIndex.indexOfSimplifier(LiteralUtils::isZero, "startsWith"), AssertJChainSimplificationIndex.indexOfSimplifier(LiteralUtils::isNegOne, "doesNotContain"), PredicateSimplifierWithContext.methodCallInSubject(LiteralUtils::isZero, Matchers.STRING_LENGTH, WithContextSimplification.msgWithActual("isEmpty")), PredicateSimplifierWithContext.methodCallInSubject(predicateArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(predicateArg, Matchers.STRING_LENGTH), Matchers.STRING_LENGTH, WithContextSimplification.msgWithActualExpected("hasSameSizeAs")), PredicateSimplifierWithContext.methodCallInSubject(predicateArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(predicateArg, Matchers.COLLECTION_SIZE), Matchers.COLLECTION_SIZE, WithContextSimplification.msgWithActualExpected("hasSameSizeAs")), PredicateSimplifierWithContext.withSubjectArgumentCondition(AssertJChainSimplificationIndex::isArrayLength, AssertJChainSimplificationIndex::isArrayLength, WithContextSimplification.msgWithActualExpected("hasSameSizeAs")), AssertJChainSimplificationIndex.arrayLengthSimplifier(WithContextSimplification.msgWithActualExpectedInPredicate("hasSize")), PredicateSimplifierWithContext.methodCallInSubject(MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{Matchers.STRING_LENGTH, Matchers.COLLECTION_SIZE}), WithContextSimplification.msgWithActualExpectedInPredicate("hasSize")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_LENGTH, WithContextSimplification.msgWithActualExpectedInPredicate("hasSize")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_GET_NAME, WithContextSimplification.msgWithActualExpectedInPredicate("hasName")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_GET_PARENT_AND_PARENT_FILE, WithContextSimplification.msgWithActualExpectedInPredicate("hasParent")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.PATH_GET_PARENT_AND_PARENT_FILE, WithContextSimplification.msgWithActualExpectedInPredicate("hasParentRaw")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.MAP_GET, WithContextSimplification.msgWithActualCustom("containsEntry", "key, value")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.PATH_GET_PARENT_AND_PARENT_FILE, WithContextSimplification.msgWithActualExpectedInPredicate("hasParentRaw")), PredicateSimplifierWithContext.withSubjectArgumentCondition(predicateArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(predicateArg, Matchers.EMPTY), subjectArg -> subjectArg.symbolType().is(JAVA_UTIL_OPTIONAL), OPTIONAL_EMPTY_REPLACEMENT), PredicateSimplifierWithContext.methodCallInSubject(Matchers.GET, WithContextSimplification.msgWithActualExpectedInPredicate("contains")))).put((Object)"isFalse", Arrays.asList(PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(arg, Matchers.EQUALS_METHOD) && !UnitTestUtils.isInUnitTestRelatedToObjectMethods(arg), WithContextSimplification.msgWithActualExpectedInSubject("isNotEqualTo")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.CONTENT_EQUALS, WithContextSimplification.msgWithActualExpectedInSubject("isNotEqualTo")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.EQUALS_IGNORE_CASE, WithContextSimplification.msgWithActualExpectedInSubject("isNotEqualToIgnoringCase")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.CONTAINS, WithContextSimplification.msgWithActualExpectedInSubject("doesNotContain")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.STARTS_WITH, WithContextSimplification.msgWithActualExpectedInSubject("doesNotStartWith")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.ENDS_WITH, WithContextSimplification.msgWithActualExpectedInSubject("doesNotEndWith")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.MATCHES, WithContextSimplification.msgWithActualExpectedInSubject("doesNotMatch")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> AssertJChainSimplificationHelper.ArgumentHelper.equalsTo(arg, ExpressionUtils::isNullLiteral), WithContextSimplification.msgWithActual("isNotNull")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> AssertJChainSimplificationHelper.ArgumentHelper.notEqualsTo(arg, ExpressionUtils::isNullLiteral), WithContextSimplification.msgWithActual("isNull")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(new Tree.Kind[]{Tree.Kind.LESS_THAN}), WithContextSimplification.msgWithActualExpected("isLessThan")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(new Tree.Kind[]{Tree.Kind.LESS_THAN_OR_EQUAL_TO}), WithContextSimplification.msgWithActualExpected("isLessThanOrEqualTo")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN}), WithContextSimplification.msgWithActualExpected("isGreaterThan")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN_OR_EQUAL_TO}), WithContextSimplification.msgWithActualExpected("isGreaterThanOrEqualTo")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO}), WithContextSimplification.msgWithActualExpected("isNotSameAs")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO}), WithContextSimplification.msgWithActualExpected("isSameAs")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(new Tree.Kind[]{Tree.Kind.INSTANCE_OF}), WithContextSimplification.msgWithActualCustom("isNotInstanceOf", "ExpectedClass.class")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_BLANK, WithContextSimplification.msgWithActual("isNotBlank")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_EMPTY_GENERIC, WithContextSimplification.msgWithActual("isNotEmpty")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_EXISTS, WithContextSimplification.msgWithActual("doesNotExist")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_AND_PATH_IS_ABSOLUTE, WithContextSimplification.msgWithActual("isRelative")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_PRESENT, OPTIONAL_EMPTY_REPLACEMENT), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_EMPTY_OPTIONAL, OPTIONAL_PRESENT_REPLACEMENT))).put((Object)"isNegative", Arrays.asList(AssertJChainSimplificationIndex.compareToSimplifier("isLessThan"), AssertJChainSimplificationIndex.indexOfSimplifier("doesNotContain"))).put((Object)"isEmpty", Collections.singletonList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_LIST_AND_LIST_FILE, WithContextSimplification.msgWithActual("isEmptyDirectory")))).put((Object)"isNotEmpty", Arrays.asList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.TRIM, WithContextSimplification.msgWithActual("isNotBlank")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_LIST_AND_LIST_FILE, WithContextSimplification.msgWithActual("isNotEmptyDirectory")))).put((Object)"isNotEqualTo", Arrays.asList(PredicateSimplifierWithContext.withSubjectArgumentCondition(AssertJChainSimplificationIndex::isZeroIntOrLong, AssertJChainSimplificationIndex::isNotObject, "isNotZero()"), AssertJChainSimplificationIndex.compareToSimplifier(LiteralUtils::isZero, "isNotEqualByComparingTo"), PredicateSimplifierWithContext.methodCallInSubject(LiteralUtils::isZero, Matchers.COMPARE_TO_IGNORE_CASE, WithContextSimplification.msgWithActualExpectedInSubject("isNotEqualToIgnoringCase")), AssertJChainSimplificationIndex.indexOfSimplifier(LiteralUtils::isZero, "doesNotStartWith"), PredicateSimplifierWithContext.methodCallInSubject(LiteralUtils::isEmptyString, Matchers.TRIM, WithContextSimplification.msgWithActual("isNotBlank")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.MAP_GET, WithContextSimplification.msgWithActualCustom("doesNotContainEntry", "key, value")), PredicateSimplifierWithContext.methodCallInSubject(LiteralUtils::isEmptyString, Matchers.TRIM, WithContextSimplification.msgWithActual("isNotBlank")), PredicateSimplifierWithContext.withSubjectArgumentCondition(predicateArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(predicateArg, Matchers.EMPTY), subjectArg -> subjectArg.symbolType().is(JAVA_UTIL_OPTIONAL), OPTIONAL_PRESENT_REPLACEMENT))).put((Object)"isNotNegative", Arrays.asList(AssertJChainSimplificationIndex.compareToSimplifier("isGreaterThanOrEqualTo"), AssertJChainSimplificationIndex.indexOfSimplifier("contains"))).put((Object)"isNotNull", Collections.singletonList(PredicateSimplifierWithContext.withSubjectArgumentCondition(subjectArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(subjectArg, Matchers.OR_ELSE) && ExpressionUtils.isNullLiteral((ExpressionTree)((ExpressionTree)((MethodInvocationTree)subjectArg).arguments().get(0))), OPTIONAL_PRESENT_REPLACEMENT))).put((Object)"isNotPositive", Arrays.asList(AssertJChainSimplificationIndex.compareToSimplifier("isLessThanOrEqualTo"), PredicateSimplifierWithContext.methodCallInSubject(Matchers.STRING_LENGTH, WithContextSimplification.msgWithActual("isEmpty")))).put((Object)"isNotZero", Arrays.asList(AssertJChainSimplificationIndex.compareToSimplifier("isNotEqualByComparingTo"), PredicateSimplifierWithContext.methodCallInSubject(Matchers.COMPARE_TO_IGNORE_CASE, WithContextSimplification.msgWithActualExpectedInSubject("isNotEqualToIgnoringCase")), AssertJChainSimplificationIndex.indexOfSimplifier("doesNotStartWith"), PredicateSimplifierWithContext.methodCallInSubject(Matchers.STRING_LENGTH, WithContextSimplification.msgWithActual("isNotEmpty")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_LENGTH, WithContextSimplification.msgWithActual("isNotEmpty")), AssertJChainSimplificationIndex.arrayLengthSimplifier(WithContextSimplification.msgWithActual("isNotEmpty")))).put((Object)"isPositive", Arrays.asList(AssertJChainSimplificationIndex.compareToSimplifier("isGreaterThan"), PredicateSimplifierWithContext.methodCallInSubject(MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{Matchers.STRING_LENGTH, Matchers.COLLECTION_SIZE}), WithContextSimplification.msgWithActual("isNotEmpty")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_LENGTH, WithContextSimplification.msgWithActual("isNotEmpty")), AssertJChainSimplificationIndex.arrayLengthSimplifier(WithContextSimplification.msgWithActual("isNotEmpty")))).put((Object)"isSameAs", Collections.singletonList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.GET, WithContextSimplification.msgWithActualExpectedInPredicate("containsSame")))).put((Object)"isTrue", Arrays.asList(PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(arg, Matchers.EQUALS_METHOD) && !UnitTestUtils.isInUnitTestRelatedToObjectMethods(arg), WithContextSimplification.msgWithActualExpectedInSubject("isEqualTo")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.CONTENT_EQUALS, WithContextSimplification.msgWithActualExpectedInSubject("isEqualTo")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.EQUALS_IGNORE_CASE, WithContextSimplification.msgWithActualExpectedInSubject("isEqualToIgnoringCase")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.CONTAINS, WithContextSimplification.msgWithActualExpectedInSubject("contains")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.COLLECTION_CONTAINS_ALL, WithContextSimplification.msgWithActualExpectedInSubject("containsAll")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.STARTS_WITH, WithContextSimplification.msgWithActualExpectedInSubject("startsWith")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.ENDS_WITH, WithContextSimplification.msgWithActualExpectedInSubject("endsWith")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.MATCHES, WithContextSimplification.msgWithActualExpectedInSubject("matches")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> AssertJChainSimplificationHelper.ArgumentHelper.equalsTo(arg, ExpressionUtils::isNullLiteral), WithContextSimplification.msgWithActual("isNull")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> AssertJChainSimplificationHelper.ArgumentHelper.notEqualsTo(arg, ExpressionUtils::isNullLiteral), WithContextSimplification.msgWithActual("isNotNull")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(new Tree.Kind[]{Tree.Kind.LESS_THAN}), WithContextSimplification.msgWithActualExpected("isLessThan")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(new Tree.Kind[]{Tree.Kind.LESS_THAN_OR_EQUAL_TO}), WithContextSimplification.msgWithActualExpected("isLessThanOrEqualTo")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN}), WithContextSimplification.msgWithActualExpected("isGreaterThan")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN_OR_EQUAL_TO}), WithContextSimplification.msgWithActualExpected("isGreaterThanOrEqualTo")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO}), WithContextSimplification.msgWithActualExpected("isSameAs")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO}), WithContextSimplification.msgWithActualExpected("isNotSameAs")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(new Tree.Kind[]{Tree.Kind.INSTANCE_OF}), WithContextSimplification.msgWithActualCustom("isInstanceOf", "ExpectedClass.class")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_BLANK, WithContextSimplification.msgWithActual("isBlank")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_EMPTY_GENERIC, WithContextSimplification.msgWithActual("isEmpty")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_CAN_READ, WithContextSimplification.msgWithActual("canRead")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_CAN_WRITE, WithContextSimplification.msgWithActual("canWrite")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_EXISTS, WithContextSimplification.msgWithActual("exists")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_AND_PATH_IS_ABSOLUTE, WithContextSimplification.msgWithActual("isAbsolute")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_IS_DIRECTORY, WithContextSimplification.msgWithActual("isDirectory")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_IS_FILE, WithContextSimplification.msgWithActual("isFile")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.PATH_STARTS_WITH, WithContextSimplification.msgWithActualExpectedInSubject("startsWithRaw")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.PATH_ENDS_WITH, WithContextSimplification.msgWithActualExpectedInSubject("endsWithRaw")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_EMPTY_GENERIC, WithContextSimplification.msgWithActual("isEmpty")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.MAP_CONTAINS_KEY, WithContextSimplification.msgWithActualExpectedInSubject("containsKey")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.MAP_CONTAINS_VALUE, WithContextSimplification.msgWithActualExpectedInSubject("containsValue")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_PRESENT, OPTIONAL_PRESENT_REPLACEMENT), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_EMPTY_OPTIONAL, OPTIONAL_EMPTY_REPLACEMENT))).put((Object)"isZero", Arrays.asList(AssertJChainSimplificationIndex.compareToSimplifier("isEqualByComparingTo"), PredicateSimplifierWithContext.methodCallInSubject(Matchers.COMPARE_TO_IGNORE_CASE, WithContextSimplification.msgWithActualExpectedInSubject("isEqualToIgnoringCase")), AssertJChainSimplificationIndex.indexOfSimplifier("startsWith"), PredicateSimplifierWithContext.methodCallInSubject(Matchers.STRING_LENGTH, WithContextSimplification.msgWithActual("isEmpty")), PredicateSimplifierWithContext.methodCallInSubject(MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{Matchers.STRING_LENGTH, Matchers.COLLECTION_SIZE}), WithContextSimplification.msgWithActual("isEmpty")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_LENGTH, WithContextSimplification.msgWithActual("isEmpty")), AssertJChainSimplificationIndex.arrayLengthSimplifier(WithContextSimplification.msgWithActual("isEmpty")))).put((Object)"isNull", Arrays.asList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_GET_PARENT_AND_PARENT_FILE, WithContextSimplification.msgWithActual("hasNoParent")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.PATH_GET_PARENT_AND_PARENT_FILE, WithContextSimplification.msgWithActual("hasNoParentRaw")), PredicateSimplifierWithContext.withSubjectArgumentCondition(subjectArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(subjectArg, Matchers.OR_ELSE) && ExpressionUtils.isNullLiteral((ExpressionTree)((ExpressionTree)((MethodInvocationTree)subjectArg).arguments().get(0))), OPTIONAL_EMPTY_REPLACEMENT))).put((Object)"isLessThanOrEqualTo", Arrays.asList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.COLLECTION_SIZE, WithContextSimplification.msgWithActualExpectedInPredicate("hasSizeLessThanOrEqualTo")), AssertJChainSimplificationIndex.arrayLengthSimplifier(WithContextSimplification.msgWithActualExpectedInPredicate("hasSizeLessThanOrEqualTo")))).put((Object)"isLessThan", Arrays.asList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.COLLECTION_SIZE, WithContextSimplification.msgWithActualExpectedInPredicate("hasSizeLessThan")), AssertJChainSimplificationIndex.arrayLengthSimplifier(WithContextSimplification.msgWithActualExpectedInPredicate("hasSizeLessThan")))).put((Object)"isGreaterThanOrEqualTo", Arrays.asList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.COLLECTION_SIZE, WithContextSimplification.msgWithActualExpectedInPredicate("hasSizeGreaterThanOrEqualTo")), AssertJChainSimplificationIndex.arrayLengthSimplifier(WithContextSimplification.msgWithActualExpectedInPredicate("hasSizeGreaterThanOrEqualTo")))).put((Object)"isGreaterThan", Arrays.asList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.COLLECTION_SIZE, WithContextSimplification.msgWithActualExpectedInPredicate("hasSizeGreaterThan")), AssertJChainSimplificationIndex.arrayLengthSimplifier(WithContextSimplification.msgWithActualExpectedInPredicate("hasSizeGreaterThan")))).put((Object)"contains", Arrays.asList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.MAP_KEY_SET, WithContextSimplification.msgWithActualExpectedInPredicate("containsKey")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.MAP_VALUES, WithContextSimplification.msgWithActualExpectedInPredicate("containsValue")))).put((Object)"containsOnly", Collections.singletonList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.MAP_KEY_SET, WithContextSimplification.msgWithActualExpectedInPredicate("containsOnlyKeys")))).build();

    private AssertJChainSimplificationIndex() {
    }

    private static PredicateSimplifierWithContext compareToSimplifier(Predicate<ExpressionTree> predicateArgCondition, String simplification) {
        return PredicateSimplifierWithContext.methodCallInSubject(predicateArgCondition, Matchers.COMPARE_TO, WithContextSimplification.msgWithActualExpectedInSubject(simplification));
    }

    private static PredicateSimplifierWithContext compareToSimplifier(String simplification) {
        return PredicateSimplifierWithContext.methodCallInSubject(Matchers.COMPARE_TO, WithContextSimplification.msgWithActualExpectedInSubject(simplification));
    }

    private static PredicateSimplifierWithContext indexOfSimplifier(Predicate<ExpressionTree> predicateArgCondition, String simplification) {
        return PredicateSimplifierWithContext.methodCallInSubject(predicateArgCondition, Matchers.INDEX_OF_STRING, WithContextSimplification.msgWithActualExpectedInSubject(simplification));
    }

    private static PredicateSimplifierWithContext indexOfSimplifier(String simplification) {
        return PredicateSimplifierWithContext.methodCallInSubject(Matchers.INDEX_OF_STRING, WithContextSimplification.msgWithActualExpectedInSubject(simplification));
    }

    private static PredicateSimplifierWithContext arrayLengthSimplifier(WithContextSimplification simplification) {
        return PredicateSimplifierWithContext.withSubjectArgumentCondition(AssertJChainSimplificationIndex::isArrayLength, simplification);
    }

    public static boolean isZeroIntOrLong(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.LONG_LITERAL})) {
            String value = ((LiteralTree)tree).value();
            return "0L".equals(value) || "0l".equals(value);
        }
        return LiteralUtils.isZero((ExpressionTree)tree);
    }

    public static boolean isOneIntOrLong(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.LONG_LITERAL})) {
            String value = ((LiteralTree)tree).value();
            return "1L".equals(value) || "1l".equals(value);
        }
        return LiteralUtils.isOne((ExpressionTree)tree);
    }

    public static boolean isNegOneIntOrLong(ExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS}) && AssertJChainSimplificationIndex.isOneIntOrLong(((UnaryExpressionTree)tree).expression());
    }

    private static boolean isArrayLength(ExpressionTree expression) {
        MemberSelectExpressionTree memberSelectExpressionTree;
        if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (memberSelectExpressionTree = (MemberSelectExpressionTree)expression).expression().symbolType().isArray()) {
            return LENGTH.equals(memberSelectExpressionTree.identifier().name());
        }
        return false;
    }

    private static boolean isCollectionSize(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree invocation = (MethodInvocationTree)expression;
            if (invocation.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                return Matchers.COLLECTION_SIZE.matches(invocation);
            }
        }
        return false;
    }

    private static boolean isStringLength(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree invocation = (MethodInvocationTree)expression;
            if (invocation.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                return Matchers.STRING_LENGTH.matches(invocation);
            }
        }
        return false;
    }

    private static boolean isNotObject(ExpressionTree expression) {
        return !expression.symbolType().is("java.lang.Object");
    }

    private static class Matchers {
        public static final MethodMatchers COMPARE_TO = MethodMatchers.create().ofSubTypes(new String[]{"java.lang.Comparable"}).names(new String[]{"compareTo"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers COMPARE_TO_IGNORE_CASE = MethodMatchers.create().ofSubTypes(new String[]{"java.lang.String"}).names(new String[]{"compareToIgnoreCase"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers CONTAINS = MethodMatchers.create().ofSubTypes(new String[]{"java.lang.String", "java.util.Collection"}).names(new String[]{"contains"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers CONTENT_EQUALS = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"contentEquals"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers EMPTY = MethodMatchers.create().ofTypes(new String[]{"java.util.Optional"}).names(new String[]{"empty"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers ENDS_WITH = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"endsWith"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers EQUALS_IGNORE_CASE = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"equalsIgnoreCase"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers EQUALS_METHOD = MethodMatchers.create().ofAnyType().names(new String[]{"equals"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers HASH_CODE = MethodMatchers.create().ofAnyType().names(new String[]{"hashCode"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers INDEX_OF_STRING = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"indexOf"}).addParametersMatcher(new String[]{"java.lang.String"}).build();
        public static final MethodMatchers IS_BLANK = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"isBlank"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers IS_EMPTY_GENERIC = MethodMatchers.create().ofSubTypes(new String[]{"java.lang.String", "java.util.Collection", "java.util.Map"}).names(new String[]{"isEmpty"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers IS_EMPTY_OPTIONAL = MethodMatchers.create().ofTypes(new String[]{"java.util.Optional"}).names(new String[]{"isEmpty"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers IS_PRESENT = MethodMatchers.create().ofTypes(new String[]{"java.util.Optional"}).names(new String[]{"isPresent"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers STRING_LENGTH = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"length"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_LENGTH = MethodMatchers.create().ofTypes(new String[]{"java.io.File"}).names(new String[]{"length"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers MATCHES = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"matches"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers STARTS_WITH = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"startsWith"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers TO_STRING = MethodMatchers.create().ofAnyType().names(new String[]{"toString"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers TRIM = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"trim"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_CAN_READ = MethodMatchers.create().ofTypes(new String[]{"java.io.File"}).names(new String[]{"canRead"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_CAN_WRITE = MethodMatchers.create().ofTypes(new String[]{"java.io.File"}).names(new String[]{"canWrite"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_EXISTS = MethodMatchers.create().ofTypes(new String[]{"java.io.File"}).names(new String[]{"exists"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_GET_NAME = MethodMatchers.create().ofTypes(new String[]{"java.io.File"}).names(new String[]{"getName"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_GET_PARENT_AND_PARENT_FILE = MethodMatchers.create().ofTypes(new String[]{"java.io.File"}).names(new String[]{"getParent", "getParentFile"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_AND_PATH_IS_ABSOLUTE = MethodMatchers.create().ofTypes(new String[]{"java.io.File", "java.nio.file.Path"}).names(new String[]{"isAbsolute"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_IS_DIRECTORY = MethodMatchers.create().ofTypes(new String[]{"java.io.File"}).names(new String[]{"isDirectory"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_IS_FILE = MethodMatchers.create().ofTypes(new String[]{"java.io.File"}).names(new String[]{"isFile"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_LIST_AND_LIST_FILE = MethodMatchers.create().ofTypes(new String[]{"java.io.File"}).names(new String[]{"list", "listFiles"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers GET = MethodMatchers.create().ofTypes(new String[]{"java.util.Optional"}).names(new String[]{"get"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers OR_ELSE = MethodMatchers.create().ofTypes(new String[]{"java.util.Optional"}).names(new String[]{"orElse"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers PATH_GET_PARENT_AND_PARENT_FILE = MethodMatchers.create().ofTypes(new String[]{"java.nio.file.Path"}).names(new String[]{"getParent"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers PATH_STARTS_WITH = MethodMatchers.create().ofTypes(new String[]{"java.nio.file.Path"}).names(new String[]{"startsWith"}).addParametersMatcher(new String[]{"java.lang.String"}).build();
        public static final MethodMatchers PATH_ENDS_WITH = MethodMatchers.create().ofTypes(new String[]{"java.nio.file.Path"}).names(new String[]{"endsWith"}).addParametersMatcher(new String[]{"java.lang.String"}).build();
        public static final MethodMatchers COLLECTION_SIZE = MethodMatchers.create().ofSubTypes(new String[]{"java.util.Collection", "java.util.Map"}).names(new String[]{"size"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers COLLECTION_CONTAINS_ALL = MethodMatchers.create().ofSubTypes(new String[]{"java.util.Collection"}).names(new String[]{"containsAll"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers MAP_CONTAINS_KEY = MethodMatchers.create().ofSubTypes(new String[]{"java.util.Map"}).names(new String[]{"containsKey"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers MAP_CONTAINS_VALUE = MethodMatchers.create().ofSubTypes(new String[]{"java.util.Map"}).names(new String[]{"containsValue"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers MAP_GET = MethodMatchers.create().ofSubTypes(new String[]{"java.util.Map"}).names(new String[]{"get"}).addParametersMatcher(new String[]{"*"}).build();
        public static final MethodMatchers MAP_KEY_SET = MethodMatchers.create().ofSubTypes(new String[]{"java.util.Map"}).names(new String[]{"keySet"}).addWithoutParametersMatcher().build();
        public static final MethodMatchers MAP_VALUES = MethodMatchers.create().ofSubTypes(new String[]{"java.util.Map"}).names(new String[]{"values"}).addWithoutParametersMatcher().build();

        private Matchers() {
        }
    }

    static class WithContextSimplification
    extends Simplification {
        private static final String MESSAGE_ACTUAL_EXPECTED = "assertThat(actual).%s(expected)";
        AssertJChainSimplificationQuickFix buildQuickFix;

        WithContextSimplification(String replacement) {
            super(replacement);
            this.buildQuickFix = new NoQuickFix();
        }

        WithContextSimplification(String replacement, AssertJChainSimplificationQuickFix buildQuickFix) {
            super(replacement);
            this.buildQuickFix = buildQuickFix;
        }

        public void buildQuickFix(MethodInvocationTree subject, MethodInvocationTree predicate) {
            this.quickFix = this.buildQuickFix.apply(subject, predicate);
        }

        static WithContextSimplification msgWithActual(String predicateName) {
            String replacement = String.format("assertThat(actual).%s()", predicateName);
            return new WithContextSimplification(replacement, new ActualExpectedInPredicateQuickFix(replacement, predicateName, false));
        }

        static WithContextSimplification msgWithActualExpected(String predicateName) {
            return new WithContextSimplification(String.format(MESSAGE_ACTUAL_EXPECTED, predicateName));
        }

        static WithContextSimplification msgWithActualExpectedInSubject(String predicateName) {
            String replacement = String.format(MESSAGE_ACTUAL_EXPECTED, predicateName);
            return new WithContextSimplification(replacement, new ActualExpectedInSubjectQuickFix(replacement, predicateName));
        }

        static WithContextSimplification msgWithActualExpectedInPredicate(String predicateName) {
            String replacement = String.format(MESSAGE_ACTUAL_EXPECTED, predicateName);
            return new WithContextSimplification(replacement, new ActualExpectedInPredicateQuickFix(replacement, predicateName, true));
        }

        static WithContextSimplification msgWithActualCustom(String predicateName, String predicateArg) {
            return new WithContextSimplification(String.format("assertThat(actual).%s(%s)", predicateName, predicateArg));
        }
    }

    static class PredicateSimplifierWithContext
    implements AssertJChainSimplificationCheck.SimplifierWithContext {
        private final Predicate<MethodInvocationTree> predicateCondition;
        private final Predicate<MethodInvocationTree> subjectCondition;
        private final WithContextSimplification simplification;

        public PredicateSimplifierWithContext(Predicate<MethodInvocationTree> predicateCondition, Predicate<MethodInvocationTree> subjectCondition, WithContextSimplification simplification) {
            this.predicateCondition = predicateCondition;
            this.subjectCondition = subjectCondition;
            this.simplification = simplification;
        }

        public static PredicateSimplifierWithContext withSubjectArgumentCondition(Predicate<ExpressionTree> predicateArgumentCondition, Predicate<ExpressionTree> subjectArgumentCondition, String simplification) {
            return PredicateSimplifierWithContext.withSubjectArgumentCondition(predicateArgumentCondition, subjectArgumentCondition, new WithContextSimplification(simplification, new ContextFreeQuickFix(simplification)));
        }

        public static PredicateSimplifierWithContext withSubjectArgumentCondition(Predicate<ExpressionTree> predicateArgumentCondition, Predicate<ExpressionTree> subjectArgumentCondition, WithContextSimplification simplification) {
            return new PredicateSimplifierWithContext(predicateMit -> predicateMit.arguments().size() == 1 && predicateArgumentCondition.test(ExpressionUtils.skipParentheses((ExpressionTree)((ExpressionTree)predicateMit.arguments().get(0)))), subjectMit -> subjectMit.arguments().size() == 1 && subjectArgumentCondition.test(ExpressionUtils.skipParentheses((ExpressionTree)((ExpressionTree)subjectMit.arguments().get(0)))), simplification);
        }

        public static PredicateSimplifierWithContext withSubjectArgumentCondition(Predicate<ExpressionTree> subjectArgumentCondition, WithContextSimplification simplification) {
            return new PredicateSimplifierWithContext(x -> true, subjectMit -> subjectMit.arguments().size() == 1 && subjectArgumentCondition.test(ExpressionUtils.skipParentheses((ExpressionTree)((ExpressionTree)subjectMit.arguments().get(0)))), simplification);
        }

        public static PredicateSimplifierWithContext methodCallInSubject(MethodMatchers methodCallMatcher, WithContextSimplification simplification) {
            return PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(arg, methodCallMatcher), simplification);
        }

        public static PredicateSimplifierWithContext methodCallInSubject(Predicate<ExpressionTree> predicateArgumentCondition, MethodMatchers methodCallMatcher, WithContextSimplification simplification) {
            return PredicateSimplifierWithContext.withSubjectArgumentCondition(predicateArgumentCondition, (ExpressionTree arg) -> AssertJChainSimplificationHelper.hasMethodCallAsArg(arg, methodCallMatcher), simplification);
        }

        @Override
        public Optional<Simplification> simplify(MethodInvocationTree subject, MethodInvocationTree predicate) {
            if (this.predicateCondition.test(predicate) && this.subjectCondition.test(subject)) {
                this.simplification.buildQuickFix(subject, predicate);
                return Optional.of(this.simplification);
            }
            return Optional.empty();
        }
    }

    private static class PredicateSimplifierWithoutContext
    implements AssertJChainSimplificationCheck.SimplifierWithoutContext {
        private final Predicate<MethodInvocationTree> mitPredicate;
        private final ContextFreeSimplification simplification;

        public PredicateSimplifierWithoutContext(Predicate<MethodInvocationTree> mitPredicate, String simplification) {
            this.mitPredicate = mitPredicate;
            this.simplification = new ContextFreeSimplification(simplification);
        }

        public static PredicateSimplifierWithoutContext withSingleArg(Predicate<ExpressionTree> argumentPredicate, String simplified) {
            return new PredicateSimplifierWithoutContext(mit -> {
                Arguments arguments = mit.arguments();
                return arguments.size() == 1 && argumentPredicate.test((ExpressionTree)arguments.get(0));
            }, simplified);
        }

        @Override
        public Optional<Simplification> simplify(MethodInvocationTree predicate) {
            if (this.mitPredicate.test(predicate)) {
                this.simplification.buildQuickFix(predicate);
                return Optional.of(this.simplification);
            }
            return Optional.empty();
        }
    }

    static class ContextFreeSimplification
    extends Simplification {
        ContextFreeSimplification(String replacement) {
            super(replacement);
        }

        void buildQuickFix(MethodInvocationTree predicate) {
            this.quickFix = new ContextFreeQuickFix(this.replacement).apply(predicate);
        }
    }

    static abstract class Simplification {
        String replacement;
        Supplier<List<JavaQuickFix>> quickFix = null;

        Simplification(String replacement) {
            this.replacement = replacement;
        }

        Optional<Supplier<List<JavaQuickFix>>> getQuickFix() {
            return Optional.ofNullable(this.quickFix);
        }

        String getReplacement() {
            return this.replacement;
        }
    }
}

