/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.AnnotationsHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1607")
public class IgnoredTestsCheck
extends IssuableSubscriptionVisitor {
    private static final String ORG_JUNIT_ASSUME = "org.junit.Assume";
    private static final String BOOLEAN_TYPE = "boolean";
    private static final MethodMatchers ASSUME_METHODS = MethodMatchers.create().ofTypes(new String[]{"org.junit.Assume"}).names(new String[]{"assumeTrue", "assumeFalse"}).addParametersMatcher(new String[]{"boolean"}).build();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        SymbolMetadata symbolMetadata = methodTree.symbol().metadata();
        for (String annotationName : List.of("org.junit.Ignore", "org.junit.jupiter.api.Disabled")) {
            IgnoredTestsCheck.getSilentlyIgnoredAnnotation(symbolMetadata, annotationName).ifPresent(annotationTree -> {
                String shortName = AnnotationsHelper.annotationTypeIdentifier(annotationName);
                String message = String.format("Either add an explanation about why this test is skipped or remove the \"@%s\" annotation.", shortName);
                JavaFileScannerContext.Location secondaryLocation = new JavaFileScannerContext.Location(String.format("@%s annotation skips the test", shortName), (Tree)annotationTree);
                this.context.reportIssue((JavaCheck)this, (Tree)methodTree.simpleName(), message, Collections.singletonList(secondaryLocation), null);
            });
        }
        BlockTree block = methodTree.block();
        if (block != null) {
            block.body().stream().filter(s -> s.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})).map(s -> ((ExpressionStatementTree)s).expression()).filter(s -> s.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})).map(MethodInvocationTree.class::cast).filter(arg_0 -> ((MethodMatchers)ASSUME_METHODS).matches(arg_0)).filter(IgnoredTestsCheck::hasConstantOppositeArg).forEach(mit -> {
                List<JavaFileScannerContext.Location> secondaryLocation = Collections.singletonList(new JavaFileScannerContext.Location("A constant boolean value is passed as argument, causing this test to always be skipped.", (Tree)mit.arguments()));
                this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "This assumption is called with a boolean constant; remove it or, to skip this test use an @Ignore/@Disabled annotation in combination with an explanation about why it is skipped.", secondaryLocation, null);
            });
        }
    }

    private static Optional<AnnotationTree> getSilentlyIgnoredAnnotation(SymbolMetadata symbolMetadata, String fullyQualifiedName) {
        for (SymbolMetadata.AnnotationInstance annotation : symbolMetadata.annotations()) {
            Type type = annotation.symbol().type();
            if (type.isUnknown()) {
                return Optional.empty();
            }
            if (!type.is(fullyQualifiedName)) continue;
            return annotation.values().isEmpty() ? Optional.ofNullable(symbolMetadata.findAnnotationTree(annotation)) : Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean hasConstantOppositeArg(MethodInvocationTree mit) {
        Optional result = ((ExpressionTree)mit.arguments().get(0)).asConstant(Boolean.class);
        return result.isPresent() && !((Boolean)result.get()).equals(mit.methodSymbol().name().contains("True"));
    }
}

