/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.checks.tests.AbstractJUnit5NotCompliantModifierChecker;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S5810")
public class JUnit5SilentlyIgnoreClassAndMethodCheck
extends AbstractJUnit5NotCompliantModifierChecker {
    @Override
    protected boolean isNonCompliantModifier(Modifier modifier, AbstractJUnit5NotCompliantModifierChecker.ModifierScope modifierScope) {
        return modifier == Modifier.PRIVATE || modifierScope == AbstractJUnit5NotCompliantModifierChecker.ModifierScope.INSTANCE_METHOD && modifier == Modifier.STATIC;
    }

    @Override
    protected void raiseIssueOnNonCompliantReturnType(MethodTree methodTree) {
        boolean methodReturnAValue;
        TypeTree returnType = methodTree.returnType();
        Type type = returnType.symbolType();
        boolean bl = methodReturnAValue = !type.isUnknown() && !type.isVoid();
        if (methodReturnAValue && !methodTree.symbol().metadata().isAnnotatedWith("org.junit.jupiter.api.TestFactory")) {
            ArrayList<JavaTextEdit> textEdits = new ArrayList<JavaTextEdit>();
            textEdits.add(JavaTextEdit.replaceTree((Tree)returnType, (String)"void"));
            List<ReturnStatementTree> returnStatementTrees = new ReturnStatementVisitor(methodTree).returnStatementTrees();
            returnStatementTrees.forEach(r -> textEdits.add(JavaTextEdit.removeTree((Tree)r.expression())));
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)methodTree.returnType()).withMessage("Replace the return type by void.").withQuickFix(() -> JavaQuickFix.newQuickFix((String)"Replace with void").addTextEdits(textEdits).build()).report();
        }
    }

    static final class ReturnStatementVisitor
    extends BaseTreeVisitor {
        private List<ReturnStatementTree> returnStatementTrees = new ArrayList<ReturnStatementTree>();

        ReturnStatementVisitor(MethodTree methodTree) {
            this.scan((Tree)methodTree);
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            this.returnStatementTrees.add(tree);
        }

        List<ReturnStatementTree> returnStatementTrees() {
            return Collections.unmodifiableList(this.returnStatementTrees);
        }
    }
}

