/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.expression.MemberSelectExpressionTreeImpl;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2116")
public class ArrayHashCodeAndToStringCheck
extends AbstractMethodDetection {
    private static final String ARRAYS = "java.util.Arrays";
    private QuickFixHelper.ImportSupplier importSupplier;

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofType(Type::isArray).names(new String[]{"toString", "hashCode"}).addWithoutParametersMatcher().build();
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        IdentifierTree methodTree = ExpressionUtils.methodName((MethodInvocationTree)mit);
        String methodName = methodTree.name();
        String methodCallee = QuickFixHelper.contentForTree((Tree)((MemberSelectExpressionTreeImpl)mit.methodSelect()).expression(), this.context);
        QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)methodTree).withMessage("Use \"Arrays." + methodName + "(array)\" instead.").withQuickFix(() -> this.getQuickFix(mit, methodName, methodCallee)).report();
    }

    public void leaveFile(JavaFileScannerContext context) {
        this.importSupplier = null;
    }

    private JavaQuickFix getQuickFix(MethodInvocationTree tree, String methodName, String methodCallee) {
        ArrayList<JavaTextEdit> edits = new ArrayList<JavaTextEdit>();
        this.getImportSupplier().newImportEdit(ARRAYS).ifPresent(edits::add);
        if ("toString".equals(methodName)) {
            edits.add(JavaTextEdit.replaceTree((Tree)tree, (String)("Arrays.toString(" + methodCallee + ")")));
            return JavaQuickFix.newQuickFix((String)"Use \"Arrays.toString(array)\" instead").addTextEdits(edits).build();
        }
        edits.add(JavaTextEdit.replaceTree((Tree)tree, (String)("Arrays.hashCode(" + methodCallee + ")")));
        return JavaQuickFix.newQuickFix((String)"Use \"Arrays.hashCode(array)\" instead").addTextEdits(edits).build();
    }

    private QuickFixHelper.ImportSupplier getImportSupplier() {
        if (this.importSupplier == null) {
            this.importSupplier = QuickFixHelper.newImportSupplier(this.context);
        }
        return this.importSupplier;
    }
}

