/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

@Rule(key="S5411")
public class BoxedBooleanExpressionsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String MESSAGE = "Use a primitive boolean expression here.";
    private static final String MESSAGE_QUICKFIX = "Use a primitive boolean expression";
    private static final MethodMatchers OPTIONAL_OR_ELSE = MethodMatchers.create().ofTypes(new String[]{"java.util.Optional"}).names(new String[]{"orElse"}).addParametersMatcher(new String[]{"*"}).build();
    private static final String BOOLEAN = "java.lang.Boolean";
    private static final MethodMatchers OPTIONAL_METHODS_WITH_LAMBDA_CONSUMING_NON_NULL = MethodMatchers.create().ofTypes(new String[]{"java.util.Optional"}).names(new String[]{"filter", "flatMap", "ifPresent", "ifPresentOrElse", "map"}).withAnyParameters().build();
    private JavaFileScannerContext context;
    private static final Map<Tree, IfStatementTree> ifStatementCache = new HashMap<Tree, IfStatementTree>();
    private static final Map<Symbol, ExpressionTree> firstNullCheckCache = new HashMap<Symbol, ExpressionTree>();
    private final Set<Symbol> safeSymbols = new HashSet<Symbol>();

    public void scanFile(JavaFileScannerContext context) {
        ifStatementCache.clear();
        firstNullCheckCache.clear();
        this.context = context;
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitForStatement(ForStatementTree tree) {
        if (tree.condition() != null && !this.isSafeBooleanExpression(tree.condition())) {
            this.scan(tree.initializer());
            this.scan(tree.update());
            this.scan((Tree)tree.statement());
        } else {
            super.visitForStatement(tree);
        }
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        if (!this.isSafeBooleanExpression(tree.condition())) {
            this.scan((Tree)tree.statement());
        } else {
            super.visitWhileStatement(tree);
        }
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        if (!this.isSafeBooleanExpression(tree.condition())) {
            this.scan((Tree)tree.statement());
        } else {
            super.visitDoWhileStatement(tree);
        }
    }

    public void visitIfStatement(IfStatementTree tree) {
        if (!this.isSafeBooleanExpression(tree.condition())) {
            this.scan((Tree)tree.thenStatement());
            this.scan((Tree)tree.elseStatement());
        } else {
            super.visitIfStatement(tree);
        }
    }

    public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        MethodInvocationTree methodInvocationTree;
        VariableTree lambdaFistParameter = MethodTreeUtils.lamdaArgumentAt(lambdaExpressionTree, 0);
        if (lambdaFistParameter != null && (methodInvocationTree = MethodTreeUtils.parentMethodInvocationOfArgumentAtPos((ExpressionTree)lambdaExpressionTree, 0)) != null && OPTIONAL_METHODS_WITH_LAMBDA_CONSUMING_NON_NULL.matches(methodInvocationTree)) {
            this.safeSymbols.add(lambdaFistParameter.symbol());
        }
        super.visitLambdaExpression(lambdaExpressionTree);
    }

    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        if (!this.isSafeBooleanExpression(tree.condition())) {
            this.scan((Tree)tree.trueExpression());
            this.scan((Tree)tree.falseExpression());
        } else {
            super.visitConditionalExpression(tree);
        }
    }

    private boolean isSafeBooleanExpression(ExpressionTree tree) {
        ExpressionTree boxedBoolean = BoxedBooleanExpressionsCheck.findBoxedBoolean(tree);
        if (boxedBoolean != null) {
            IdentifierTree identifierTree;
            if (BoxedBooleanExpressionsCheck.isFirstUsageANullCheck(boxedBoolean)) {
                return true;
            }
            if (boxedBoolean instanceof IdentifierTree && this.safeSymbols.contains((identifierTree = (IdentifierTree)boxedBoolean).symbol())) {
                return true;
            }
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)boxedBoolean).withMessage(MESSAGE).withQuickFixes(() -> BoxedBooleanExpressionsCheck.getQuickFix(tree, boxedBoolean)).report();
            return false;
        }
        return true;
    }

    private static boolean isFirstUsageANullCheck(ExpressionTree boxedBoolean) {
        if (boxedBoolean.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree identifier = (IdentifierTree)boxedBoolean;
            List usages = identifier.symbol().usages();
            Tree firstUsage = ((IdentifierTree)usages.get(0)).parent();
            if (firstUsage.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO}) && BoxedBooleanExpressionsCheck.isNullCheck((ExpressionTree)firstUsage)) {
                return true;
            }
            if (usages.size() == 1) {
                return false;
            }
            Optional<ExpressionTree> firstNullCheck = BoxedBooleanExpressionsCheck.getFirstNullCheck(identifier.symbol());
            if (!firstNullCheck.isPresent()) {
                return false;
            }
            Optional<IfStatementTree> ifStatementWithNullCheck = BoxedBooleanExpressionsCheck.getParentConditionalBranch((Tree)firstNullCheck.get());
            Optional<IfStatementTree> ifStatementWithFirstUsage = BoxedBooleanExpressionsCheck.getParentConditionalBranch(firstUsage);
            return ifStatementWithNullCheck.equals(ifStatementWithFirstUsage);
        }
        if (boxedBoolean.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) {
            TypeCastTree typeCast = (TypeCastTree)boxedBoolean;
            return BoxedBooleanExpressionsCheck.isFirstUsageANullCheck(typeCast.expression());
        }
        return false;
    }

    private static Optional<ExpressionTree> getFirstNullCheck(Symbol symbol) {
        if (firstNullCheckCache.containsKey(symbol)) {
            return Optional.ofNullable(firstNullCheckCache.get(symbol));
        }
        Optional<ExpressionTree> firstNullCheck = symbol.usages().stream().map(Tree::parent).filter(tree -> tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO}) && BoxedBooleanExpressionsCheck.isNullCheck((ExpressionTree)tree)).map(ExpressionTree.class::cast).findFirst();
        firstNullCheckCache.put(symbol, firstNullCheck.orElse(null));
        return firstNullCheck;
    }

    private static Optional<IfStatementTree> getParentConditionalBranch(Tree tree) {
        ArrayDeque<Tree> trees = new ArrayDeque<Tree>();
        IfStatementTree ifStatementTree = null;
        for (Tree current = tree; current != null && ifStatementTree == null; current = current.parent()) {
            if (ifStatementCache.containsKey(tree)) {
                ifStatementTree = ifStatementCache.get(tree);
            } else if (current.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
                ifStatementTree = (IfStatementTree)current;
            }
            trees.add(current);
        }
        while (!trees.isEmpty()) {
            ifStatementCache.put((Tree)trees.pop(), ifStatementTree);
        }
        return Optional.ofNullable(ifStatementTree);
    }

    @CheckForNull
    private static ExpressionTree findBoxedBoolean(ExpressionTree tree) {
        if (tree.symbolType().is(BOOLEAN) && !BoxedBooleanExpressionsCheck.isValidMethodInvocation(tree) && !BoxedBooleanExpressionsCheck.isNonnullIdentifier(tree)) {
            return tree;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
            return BoxedBooleanExpressionsCheck.findBoxedBoolean(((UnaryExpressionTree)tree).expression());
        }
        if (tree instanceof BinaryExpressionTree) {
            BinaryExpressionTree expr = (BinaryExpressionTree)tree;
            if (BoxedBooleanExpressionsCheck.findBoxedBoolean(expr.leftOperand()) != null && expr.rightOperand().symbolType().isPrimitive(Type.Primitives.BOOLEAN)) {
                return expr.leftOperand();
            }
            if (BoxedBooleanExpressionsCheck.findBoxedBoolean(expr.rightOperand()) != null && expr.leftOperand().symbolType().isPrimitive(Type.Primitives.BOOLEAN) && !BoxedBooleanExpressionsCheck.isNullCheck(expr.leftOperand())) {
                return expr.rightOperand();
            }
        }
        return null;
    }

    private static boolean isNullCheck(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO, Tree.Kind.EQUAL_TO})) {
            BinaryExpressionTree expr = (BinaryExpressionTree)tree;
            return expr.leftOperand().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) || expr.rightOperand().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
        }
        return false;
    }

    private static boolean isValidMethodInvocation(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            return BoxedBooleanExpressionsCheck.isOptionalInvocation(mit) || BoxedBooleanExpressionsCheck.isAnnotatedNonnull((Symbol)mit.methodSymbol());
        }
        return false;
    }

    private static boolean isOptionalInvocation(MethodInvocationTree mit) {
        return OPTIONAL_OR_ELSE.matches(mit) && !((ExpressionTree)mit.arguments().get(0)).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
    }

    private static boolean isNonnullIdentifier(ExpressionTree tree) {
        IdentifierTree it;
        return tree instanceof IdentifierTree && BoxedBooleanExpressionsCheck.isAnnotatedNonnull((it = (IdentifierTree)tree).symbol());
    }

    private static boolean isAnnotatedNonnull(Symbol symbol) {
        return symbol.metadata().annotations().stream().map(SymbolMetadata.AnnotationInstance::symbol).map(Symbol::name).anyMatch(name -> "nonNull".equalsIgnoreCase((String)name) || "notNull".equalsIgnoreCase((String)name));
    }

    private static List<JavaQuickFix> getQuickFix(ExpressionTree tree, ExpressionTree boxedBoolean) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && OPTIONAL_OR_ELSE.matches((MethodInvocationTree)tree)) {
            return Collections.emptyList();
        }
        ArrayList<JavaTextEdit> edits = new ArrayList<JavaTextEdit>(2);
        if (tree.is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
            edits.add(JavaTextEdit.replaceTree((Tree)((UnaryExpressionTree)tree).operatorToken(), (String)"Boolean.FALSE.equals("));
        } else {
            edits.add(JavaTextEdit.insertBeforeTree((Tree)boxedBoolean, (String)"Boolean.TRUE.equals("));
        }
        edits.add(JavaTextEdit.insertAfterTree((Tree)boxedBoolean, (String)")"));
        return Collections.singletonList(JavaQuickFix.newQuickFix((String)MESSAGE_QUICKFIX).addTextEdits(edits).build());
    }
}

