/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S1182")
public class CloneMethodCallsSuperCloneCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (CloneMethodCallsSuperCloneCheck.isCloneMethod(methodTree)) {
            CloneSuperCallVisitor visitor = new CloneSuperCallVisitor();
            tree.accept((TreeVisitor)visitor);
            if (!visitor.foundSuperCall) {
                this.reportIssue((Tree)((MethodTree)tree).simpleName(), "Use super.clone() to create and seed the cloned instance to be returned.");
            }
        }
    }

    private static boolean isCloneMethod(MethodTree methodTree) {
        return "clone".equals(methodTree.simpleName().name()) && methodTree.parameters().isEmpty() && methodTree.block() != null;
    }

    private static class CloneSuperCallVisitor
    extends BaseTreeVisitor {
        private boolean foundSuperCall;

        private CloneSuperCallVisitor() {
        }

        public void visitClass(ClassTree tree) {
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        public void visitNewClass(NewClassTree tree) {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (CloneSuperCallVisitor.isSuperCloneCall(tree)) {
                this.foundSuperCall = true;
            }
        }

        private static boolean isSuperCloneCall(MethodInvocationTree mit) {
            return mit.arguments().isEmpty() && mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && CloneSuperCallVisitor.isSuperClone((MemberSelectExpressionTree)mit.methodSelect());
        }

        private static boolean isSuperClone(MemberSelectExpressionTree tree) {
            return "clone".equals(tree.identifier().name()) && tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "super".equals(((IdentifierTree)tree.expression()).name());
        }
    }
}

