/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2234")
public class MethodParametersOrderCheck
extends IssuableSubscriptionVisitor {
    private Map<Symbol, ParametersList> parametersByMethod = new HashMap<Symbol, ParametersList>();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void setContext(JavaFileScannerContext context) {
        this.parametersByMethod.clear();
        super.setContext(context);
    }

    public void visitNode(Tree tree) {
        List<VariableTree> matchingTypesWrongOrder;
        List<IdentifierTree> argumentsList;
        MethodInvocationTree methodInvTree = (MethodInvocationTree)tree;
        MethodTree methodDeclaration = methodInvTree.methodSymbol().declaration();
        if (methodDeclaration == null) {
            return;
        }
        ParametersList formalParameterList = this.parametersByMethod.computeIfAbsent((Symbol)methodInvTree.methodSymbol(), m -> new ParametersList(methodDeclaration));
        if (MethodParametersOrderCheck.matchingNames(formalParameterList, argumentsList = methodInvTree.arguments().stream().map(this::argumentToIdentifier).toList()) && !(matchingTypesWrongOrder = MethodParametersOrderCheck.matchingTypesWrongOrder(formalParameterList, argumentsList)).isEmpty()) {
            List<JavaFileScannerContext.Location> flow = matchingTypesWrongOrder.stream().map(param -> new JavaFileScannerContext.Location("Misplaced Parameter", (Tree)param)).toList();
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)methodInvTree.arguments()).withMessage("Parameters to %s have the same names but not the same order as the method arguments.", new Object[]{methodInvTree.methodSymbol().name()}).withSecondaries(flow).report();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean matchingNames(ParametersList formalParameters, List<IdentifierTree> argumentsList) {
        List<String> argListNames = argumentsList.stream().filter(Objects::nonNull).map(arg -> arg.name().toLowerCase(Locale.ENGLISH)).toList();
        if (!MethodParametersOrderCheck.allUnique(argListNames)) return false;
        if (!argListNames.stream().allMatch(formalParameters::hasArgumentWithName)) return false;
        return true;
    }

    public IdentifierTree argumentToIdentifier(ExpressionTree expr) {
        if (expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return (IdentifierTree)ExpressionUtils.skipParentheses((ExpressionTree)expr);
        }
        if (expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return (IdentifierTree)ExpressionUtils.skipParentheses((ExpressionTree)((MemberSelectExpressionTree)expr).identifier());
        }
        return null;
    }

    public static boolean allUnique(List<String> argListNames) {
        return argListNames.size() == new HashSet<String>(argListNames).size();
    }

    private static List<VariableTree> matchingTypesWrongOrder(ParametersList formalParameterList, List<IdentifierTree> argumentList) {
        Iterator argumentsIterator = argumentList.stream().filter(Objects::nonNull).iterator();
        ArrayList<VariableTree> misplacedParameters = new ArrayList<VariableTree>();
        while (argumentsIterator.hasNext()) {
            Type argType;
            IdentifierTree argument = (IdentifierTree)argumentsIterator.next();
            int index = formalParameterList.indexOf(argument.name().toLowerCase(Locale.ENGLISH));
            Type formalType = formalParameterList.typeOfIndex(index);
            if (!formalType.is((argType = argument.symbolType()).fullyQualifiedName()) || formalType.isUnknown() || argType.isUnknown()) {
                return Collections.emptyList();
            }
            if (argumentList.indexOf(argument) == index) continue;
            misplacedParameters.add(formalParameterList.parameterAt(index));
        }
        if (misplacedParameters.size() >= 2) {
            return misplacedParameters;
        }
        return Collections.emptyList();
    }

    private static class ParametersList {
        private List<String> parameterNames = new ArrayList<String>();
        private List<Type> parameterTypes = new ArrayList<Type>();
        private List<VariableTree> parameters;

        public ParametersList(MethodTree methodTree) {
            methodTree.parameters().stream().map(VariableTree::symbol).forEach(symbol -> {
                this.parameterNames.add(symbol.name().toLowerCase(Locale.ENGLISH));
                this.parameterTypes.add(symbol.type());
            });
            this.parameters = methodTree.parameters();
        }

        public boolean hasArgumentWithName(String argument) {
            return this.parameterNames.contains(argument);
        }

        public int indexOf(String argName) {
            return this.parameterNames.indexOf(argName);
        }

        public Type typeOfIndex(int index) {
            return this.parameterTypes.get(index);
        }

        public VariableTree parameterAt(int index) {
            return this.parameters.get(index);
        }
    }
}

