/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractMissingDeprecatedChecker;
import org.sonar.java.checks.helpers.DeprecatedCheckerHelper;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="MissingDeprecatedCheck", repositoryKey="squid")
@Rule(key="S1123")
public class MissingDeprecatedCheck
extends AbstractMissingDeprecatedChecker {
    @Override
    void handleDeprecatedElement(Tree tree, @CheckForNull AnnotationTree deprecatedAnnotation, boolean hasJavadocDeprecatedTag) {
        boolean hasDeprecatedAnnotation;
        if (MissingDeprecatedCheck.isRecordComponent(tree)) {
            return;
        }
        boolean bl = hasDeprecatedAnnotation = deprecatedAnnotation != null;
        if (hasDeprecatedAnnotation) {
            if (!hasJavadocDeprecatedTag) {
                this.reportIssue(DeprecatedCheckerHelper.reportTreeForDeprecatedTree(tree), "Add the missing @deprecated Javadoc tag.");
            }
        } else if (hasJavadocDeprecatedTag) {
            this.reportIssue(DeprecatedCheckerHelper.reportTreeForDeprecatedTree(tree), "Add the missing @Deprecated annotation.");
        }
    }

    private static boolean isRecordComponent(Tree tree) {
        VariableTree variableTree;
        if (tree instanceof VariableTree && !(variableTree = (VariableTree)tree).symbol().isStatic()) {
            return Optional.ofNullable(tree.parent()).filter(parent -> parent.is(new Tree.Kind[]{Tree.Kind.RECORD})).isPresent();
        }
        return false;
    }
}

