/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2384")
public class MutableMembersUsageCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final List<String> MUTABLE_TYPES = Arrays.asList("java.util.Collection", "java.util.Date", "java.util.Map");
    private static final List<String> IMMUTABLE_TYPES = Arrays.asList("java.util.Collections.UnmodifiableCollection", "java.util.Collections.UnmodifiableMap", "com.google.common.collect.ImmutableCollection", "com.google.common.collect.ImmutableMap");
    private static final MethodMatchers UNMODIFIABLE_COLLECTION_CALL = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofType(type -> MutableMembersUsageCheck.containsImmutableLikeTerm(type.name())).anyName().withAnyParameters().build(), MethodMatchers.create().ofAnyType().name(MutableMembersUsageCheck::containsImmutableLikeTerm).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.util.Collections"}).name(name -> name.startsWith("singleton") || name.startsWith("empty")).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.util.Set", "java.util.List"}).names(new String[]{"of", "copyOf"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"com.google.common.collect.Sets"}).names(new String[]{"union", "intersection", "difference", "symmetricDifference"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"com.google.common.collect.Lists"}).names(new String[]{"asList"}).withAnyParameters().build()});
    private static final MethodMatchers STREAM_COLLECT_CALL = MethodMatchers.create().ofTypes(new String[]{"java.util.stream.Stream"}).names(new String[]{"collect"}).addParametersMatcher(new String[]{"java.util.stream.Collector"}).build();
    private static final MethodMatchers UNMODIFIABLE_COLLECTOR_CALL = MethodMatchers.create().ofTypes(new String[]{"java.util.stream.Collectors"}).names(new String[]{"toUnmodifiableSet", "toUnmodifiableList", "toUnmodifiableMap"}).withAnyParameters().build();
    private JavaFileScannerContext context;
    private final Deque<List<Symbol>> parametersStack = new LinkedList<List<Symbol>>();
    private final Deque<String> methodSignatureStack = new ArrayDeque<String>();
    private final MutableDataPropagationGraph dataPropagationGraph = new MutableDataPropagationGraph();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
        this.dataPropagationGraph.reportMutableStoreReachableByOutsideCall(context, this);
        this.dataPropagationGraph.clear();
    }

    public void visitMethod(MethodTree tree) {
        Symbol.TypeSymbol enclosingClass;
        if (tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) && (enclosingClass = tree.symbol().enclosingClass()).isEnum()) {
            return;
        }
        this.dataPropagationGraph.addMethod(tree);
        this.parametersStack.push(tree.parameters().stream().map(VariableTree::symbol).toList());
        this.methodSignatureStack.push(tree.symbol().signature());
        super.visitMethod(tree);
        this.methodSignatureStack.pop();
        this.parametersStack.pop();
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        if (!this.methodSignatureStack.isEmpty() && !this.parametersStack.isEmpty()) {
            this.dataPropagationGraph.addMethodInvocation(tree.methodSymbol(), tree.arguments(), this.methodSignatureStack.peek(), this.parametersStack.peek());
        }
        super.visitMethodInvocation(tree);
    }

    public void visitNewClass(NewClassTree tree) {
        if (!this.methodSignatureStack.isEmpty() && !this.parametersStack.isEmpty()) {
            this.dataPropagationGraph.addMethodInvocation(tree.methodSymbol(), tree.arguments(), this.methodSignatureStack.peek(), this.parametersStack.peek());
        }
        super.visitNewClass(tree);
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        super.visitAssignmentExpression(tree);
        if (!MutableMembersUsageCheck.isMutableType(tree.expression())) {
            return;
        }
        ExpressionTree variable = tree.variable();
        Symbol leftSymbol = null;
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree identifierTree = (IdentifierTree)variable;
            leftSymbol = identifierTree.symbol();
        } else if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mit = (MemberSelectExpressionTree)variable;
            leftSymbol = mit.identifier().symbol();
        }
        if (leftSymbol != null && leftSymbol.isPrivate()) {
            this.checkStore(tree.expression());
        }
    }

    private void checkStore(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            int parameterIndex;
            IdentifierTree identifierTree = (IdentifierTree)expression;
            if (!this.methodSignatureStack.isEmpty() && !this.parametersStack.isEmpty() && (parameterIndex = this.parametersStack.peek().indexOf(identifierTree.symbol())) != -1) {
                this.dataPropagationGraph.addStore(this.methodSignatureStack.peek(), identifierTree, parameterIndex);
            }
        }
    }

    public void visitReturnStatement(ReturnStatementTree tree) {
        super.visitReturnStatement(tree);
        ExpressionTree expressionTree = tree.expression();
        if (expressionTree == null || !MutableMembersUsageCheck.isMutableType(expressionTree)) {
            return;
        }
        this.checkReturnedExpression(expressionTree);
    }

    private void checkReturnedExpression(ExpressionTree expression) {
        IdentifierTree identifierTree;
        MemberSelectExpressionTree mse;
        if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && ExpressionUtils.isThis((ExpressionTree)(mse = (MemberSelectExpressionTree)expression).expression())) {
            this.checkReturnedExpression((ExpressionTree)mse.identifier());
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && (identifierTree = (IdentifierTree)expression).symbol().isPrivate() && !MutableMembersUsageCheck.isOnlyAssignedImmutableVariable((Symbol.VariableSymbol)identifierTree.symbol())) {
            this.context.reportIssue((JavaCheck)this, (Tree)identifierTree, "Return a copy of \"" + identifierTree.name() + "\".");
        }
    }

    private static boolean isOnlyAssignedImmutableVariable(Symbol.VariableSymbol symbol) {
        ExpressionTree initializer;
        VariableTree declaration = symbol.declaration();
        if (declaration != null && (initializer = declaration.initializer()) != null) {
            boolean isInitializerImmutable;
            boolean bl = isInitializerImmutable = !MutableMembersUsageCheck.isMutableType(initializer) || MutableMembersUsageCheck.isEmptyArray(initializer);
            if (symbol.isFinal() || !isInitializerImmutable) {
                return isInitializerImmutable;
            }
        }
        return !MutableMembersUsageCheck.assignementsOfMutableType(symbol.usages());
    }

    private static boolean isEmptyArray(ExpressionTree initializer) {
        return initializer.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY}) && !((NewArrayTree)initializer).dimensions().isEmpty() && ((NewArrayTree)initializer).dimensions().stream().allMatch(adt -> MutableMembersUsageCheck.isZeroLiteralValue(adt.expression()));
    }

    private static boolean isZeroLiteralValue(@Nullable ExpressionTree expressionTree) {
        if (expressionTree == null) {
            return false;
        }
        Integer integer = LiteralUtils.intLiteralValue((ExpressionTree)expressionTree);
        return integer != null && integer == 0;
    }

    private static boolean assignementsOfMutableType(List<IdentifierTree> usages) {
        Iterator<IdentifierTree> iterator = usages.iterator();
        while (iterator.hasNext()) {
            AssignmentExpressionTree assignment;
            IdentifierTree usage;
            IdentifierTree current = usage = iterator.next();
            Tree parent = usage.parent();
            while (!parent.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && (parent = (current = parent).parent()) != null) {
            }
            if (parent == null || !(assignment = (AssignmentExpressionTree)parent).variable().equals((Object)current) || !MutableMembersUsageCheck.isMutableType(assignment.expression())) continue;
            return true;
        }
        return false;
    }

    private static boolean isMutableType(ExpressionTree expressionTree) {
        MethodInvocationTree methodInvocationTree;
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
            return false;
        }
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && (UNMODIFIABLE_COLLECTION_CALL.matches(methodInvocationTree = (MethodInvocationTree)expressionTree) || MutableMembersUsageCheck.isUnmodifiableCollector(methodInvocationTree))) {
            return false;
        }
        return MutableMembersUsageCheck.isMutableType(expressionTree.symbolType());
    }

    private static boolean isUnmodifiableCollector(MethodInvocationTree methodInvocationTree) {
        if (STREAM_COLLECT_CALL.matches(methodInvocationTree) && ((ExpressionTree)methodInvocationTree.arguments().get(0)).is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree collector = (MethodInvocationTree)methodInvocationTree.arguments().get(0);
            return UNMODIFIABLE_COLLECTOR_CALL.matches(collector);
        }
        return false;
    }

    private static boolean isMutableType(Type type) {
        if (type.isArray()) {
            return true;
        }
        for (String mutableType : MUTABLE_TYPES) {
            if (!type.isSubtypeOf(mutableType) || !MutableMembersUsageCheck.isNotImmutable(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNotImmutable(Type type) {
        for (String immutableType : IMMUTABLE_TYPES) {
            if (!type.isSubtypeOf(immutableType)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsImmutableLikeTerm(String methodName) {
        String lowerCaseName = methodName.toLowerCase(Locale.ROOT);
        return lowerCaseName.contains("unmodifiable") || lowerCaseName.contains("immutable");
    }

    private static class MutableDataPropagationGraph {
        private final Map<String, List<CallSite>> callGraph = new HashMap<String, List<CallSite>>();
        private final Map<String, List<ParameterStore>> mutableStoredByMethod = new HashMap<String, List<ParameterStore>>();
        private final Set<String> nonPrivateMethods = new HashSet<String>();
        private static final List<CallSite> EMPTY_CALL_SITE_LIST = new ArrayList<CallSite>();

        private MutableDataPropagationGraph() {
        }

        public void clear() {
            this.mutableStoredByMethod.clear();
            this.callGraph.clear();
            this.nonPrivateMethods.clear();
        }

        private List<MethodEntryPoint> findEntryPointsWithOutgoingEdges(String methodSignature) {
            return this.callGraph.getOrDefault(methodSignature, EMPTY_CALL_SITE_LIST).stream().flatMap(callSite -> callSite.parameters().stream()).map(ArgumentParameterMapping::parameterIndex).distinct().map(parameter -> new MethodEntryPoint(methodSignature, (Integer)parameter)).toList();
        }

        public void reportMutableStoreReachableByOutsideCall(JavaFileScannerContext context, JavaFileScanner check) {
            HashSet reachableMutableStore = new HashSet();
            this.mutableStoredByMethod.entrySet().stream().filter(entry -> this.nonPrivateMethods.contains(entry.getKey())).forEach(entry -> reachableMutableStore.addAll((Collection)entry.getValue()));
            ArrayDeque<MethodEntryPoint> toProcess = new ArrayDeque<MethodEntryPoint>();
            for (String method : this.nonPrivateMethods) {
                toProcess.addAll(this.findEntryPointsWithOutgoingEdges(method));
            }
            HashSet<MethodEntryPoint> explored = new HashSet<MethodEntryPoint>();
            while (!toProcess.isEmpty()) {
                MethodEntryPoint current = (MethodEntryPoint)toProcess.pop();
                if (!explored.add(current)) continue;
                if (this.mutableStoredByMethod.containsKey(current.methodSignature())) {
                    this.mutableStoredByMethod.get(current.methodSignature()).stream().filter(parameterStore -> parameterStore.parameterIndex == current.paramIndex()).forEach(reachableMutableStore::add);
                }
                List<CallSite> callSites = this.callGraph.getOrDefault(current.methodSignature(), EMPTY_CALL_SITE_LIST);
                for (CallSite callSite : callSites) {
                    callSite.parameters.stream().filter(mapping -> mapping.parameterIndex == current.paramIndex()).map(mapping -> new MethodEntryPoint(callSite.methodSignature, mapping.argumentIndex)).forEach(toProcess::add);
                }
            }
            for (ParameterStore parameterStore2 : reachableMutableStore) {
                context.reportIssue((JavaCheck)check, (Tree)parameterStore2.memberId, "Store a copy of \"" + parameterStore2.memberId.name() + "\".");
            }
        }

        public void addMethod(MethodTree tree) {
            if (!tree.symbol().isPrivate()) {
                this.nonPrivateMethods.add(tree.symbol().signature());
            }
        }

        public void addMethodInvocation(Symbol.MethodSymbol methodSymbol, Arguments arguments, String callerSignature, List<Symbol> callerParameters) {
            List<ArgumentParameterMapping> mutableParameters = MutableDataPropagationGraph.findMutableParameters(arguments, callerParameters);
            this.callGraph.computeIfAbsent(callerSignature, s -> new ArrayList()).add(new CallSite(methodSymbol.signature(), mutableParameters));
        }

        private static List<ArgumentParameterMapping> findMutableParameters(Arguments arguments, List<Symbol> parameters) {
            ArrayList<ArgumentParameterMapping> result = new ArrayList<ArgumentParameterMapping>();
            for (int i = 0; i < arguments.size(); ++i) {
                IdentifierTree id;
                int correspondingParameterIndex;
                ExpressionTree arg = (ExpressionTree)arguments.get(i);
                if (!MutableMembersUsageCheck.isMutableType(arg) || !(arg instanceof IdentifierTree) || (correspondingParameterIndex = parameters.indexOf((id = (IdentifierTree)arg).symbol())) == -1) continue;
                result.add(new ArgumentParameterMapping(correspondingParameterIndex, i));
            }
            return result;
        }

        public void addStore(String methodSignature, IdentifierTree assignedMember, int parameterIndex) {
            this.mutableStoredByMethod.computeIfAbsent(methodSignature, k -> new ArrayList()).add(new ParameterStore(assignedMember, parameterIndex));
        }

        private record MethodEntryPoint(String methodSignature, Integer paramIndex) {
        }
    }

    private record ParameterStore(IdentifierTree memberId, int parameterIndex) {
    }

    @VisibleForTesting
    record CallSite(String methodSignature, List<ArgumentParameterMapping> parameters) {
        @Override
        public String toString() {
            return "{" + this.methodSignature + ", <" + this.parameters.stream().map(entry -> entry.parameterIndex + "->" + entry.argumentIndex).collect(Collectors.joining(", ")) + ">}";
        }
    }

    @VisibleForTesting
    record ArgumentParameterMapping(int parameterIndex, int argumentIndex) {
    }
}

