/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6207")
public class RedundantRecordMethodsCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.RECORD);
    }

    public void visitNode(Tree tree) {
        ClassTree targetRecord = (ClassTree)tree;
        List<Symbol.VariableSymbol> components = targetRecord.recordComponents().stream().map(VariableTree::symbol).filter(Symbol.VariableSymbol.class::isInstance).map(Symbol.VariableSymbol.class::cast).toList();
        Set<String> componentNames = components.stream().map(Symbol::name).collect(Collectors.toSet());
        for (Tree member : targetRecord.members()) {
            if (member.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
                this.checkConstructor((MethodTree)member, components);
                continue;
            }
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD})) continue;
            this.checkMethod((MethodTree)member, components, componentNames);
        }
    }

    private void checkConstructor(MethodTree constructor, List<Symbol.VariableSymbol> components) {
        if (RedundantRecordMethodsCheck.isAnnotated(constructor)) {
            return;
        }
        if (constructor.block().body().isEmpty() || RedundantRecordMethodsCheck.onlyDoesSimpleAssignments(constructor, components)) {
            this.reportIssue((Tree)constructor.simpleName(), "Remove this redundant constructor which is the same as a default one.");
        }
    }

    private void checkMethod(MethodTree method, List<Symbol.VariableSymbol> components, Set<String> componentsByName) {
        String methodName = method.symbol().name();
        if (!componentsByName.contains(methodName)) {
            return;
        }
        if (RedundantRecordMethodsCheck.onlyReturnsRawValue(method, components)) {
            this.reportIssue((Tree)method.simpleName(), "Remove this redundant method which is the same as a default one.");
        }
    }

    public static boolean onlyReturnsRawValue(MethodTree method, Collection<Symbol.VariableSymbol> components) {
        Symbol identifierSymbol;
        Optional<ReturnStatementTree> returnStatement = RedundantRecordMethodsCheck.getFirstReturnStatement(method);
        if (!returnStatement.isPresent()) {
            return false;
        }
        ExpressionTree expression = returnStatement.get().expression();
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            identifierSymbol = ((IdentifierTree)expression).symbol();
        } else if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            identifierSymbol = ((MemberSelectExpressionTree)expression).identifier().symbol();
        } else {
            return false;
        }
        return components.stream().anyMatch(arg_0 -> ((Symbol)identifierSymbol).equals(arg_0));
    }

    private static Optional<ReturnStatementTree> getFirstReturnStatement(MethodTree method) {
        return method.block().body().stream().filter(statement -> statement.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})).map(ReturnStatementTree.class::cast).findFirst();
    }

    public static boolean onlyDoesSimpleAssignments(MethodTree constructor, List<Symbol.VariableSymbol> components) {
        if (constructor.parameters().size() != components.size()) {
            return false;
        }
        List<String> componentNames = components.stream().map(Symbol::name).toList();
        ConstructorExecutionState executionState = new ConstructorExecutionState(componentNames);
        constructor.block().body().forEach(executionState::applyStatement);
        return executionState.componentsAreFullyAssigned();
    }

    private static boolean isAnnotated(MethodTree method) {
        return !method.modifiers().annotations().isEmpty();
    }

    private static class ConstructorExecutionState {
        final List<String> componentNames;
        Set<String> assignedComponents = new HashSet<String>();
        Set<String> unchangedParameters;

        private ConstructorExecutionState(List<String> componentNames) {
            this.componentNames = componentNames;
            this.unchangedParameters = new HashSet<String>();
            this.unchangedParameters.addAll(componentNames);
        }

        private boolean isParameter(Symbol symbol) {
            return this.componentNames.contains(symbol.name());
        }

        public Optional<String> getComponent(ExpressionTree expression) {
            MemberSelectExpressionTree memberSelect;
            String name;
            if (expression instanceof MemberSelectExpressionTree && this.componentNames.contains(name = (memberSelect = (MemberSelectExpressionTree)expression).identifier().name())) {
                return Optional.of(name);
            }
            return Optional.empty();
        }

        private void applyAssignment(ExpressionTree lhs, ExpressionTree rhs) {
            IdentifierTree identifier;
            IdentifierTree identifier2;
            if (rhs instanceof IdentifierTree && this.isParameter((identifier2 = (IdentifierTree)rhs).symbol()) && this.unchangedParameters.contains(identifier2.name())) {
                this.getComponent(lhs).filter(name -> name.equals(identifier2.name())).ifPresent(this.assignedComponents::add);
            } else if (lhs instanceof IdentifierTree && this.isParameter((identifier = (IdentifierTree)lhs).symbol())) {
                this.unchangedParameters.remove(identifier.name());
            }
        }

        private ConstructorExecutionState copy() {
            ConstructorExecutionState copy = new ConstructorExecutionState(this.componentNames);
            copy.unchangedParameters.clear();
            copy.unchangedParameters.addAll(this.unchangedParameters);
            copy.assignedComponents.addAll(this.assignedComponents);
            return copy;
        }

        private void mergeWith(ConstructorExecutionState other) {
            this.assignedComponents.removeIf(component -> !other.assignedComponents.contains(component));
            this.unchangedParameters.removeIf(component -> !other.unchangedParameters.contains(component));
        }

        public void applyStatement(StatementTree statement) {
            ExpressionStatementTree expression;
            ExpressionTree expressionTree;
            if (statement instanceof ExpressionStatementTree && (expressionTree = (expression = (ExpressionStatementTree)statement).expression()) instanceof AssignmentExpressionTree) {
                AssignmentExpressionTree assignment = (AssignmentExpressionTree)expressionTree;
                this.applyAssignment(assignment.variable(), assignment.expression());
            } else if (statement instanceof IfStatementTree) {
                IfStatementTree ifStatement = (IfStatementTree)statement;
                ConstructorExecutionState stateCopy = this.copy();
                this.applyStatement(ifStatement.thenStatement());
                StatementTree elseStatement = ifStatement.elseStatement();
                if (elseStatement != null) {
                    stateCopy.applyStatement(elseStatement);
                }
                this.mergeWith(stateCopy);
            } else if (statement instanceof BlockTree) {
                BlockTree block = (BlockTree)statement;
                block.body().forEach(this::applyStatement);
            }
        }

        public boolean componentsAreFullyAssigned() {
            return this.assignedComponents.size() == this.componentNames.size();
        }
    }
}

