/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.tree.InferedTypeTree;
import org.sonar.plugins.java.api.tree.PatternTree;
import org.sonar.plugins.java.api.tree.RecordPatternTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypePatternTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S7475")
public class RemoveTypeFromUnusedPatternCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.RECORD_PATTERN);
    }

    public void visitNode(Tree tree) {
        RecordPatternTree pattern = (RecordPatternTree)tree;
        for (PatternTree patternTree : pattern.patterns()) {
            TypePatternTree pat;
            if (!(patternTree instanceof TypePatternTree) || !(pat = (TypePatternTree)patternTree).patternVariable().simpleName().isUnnamedVariable() || RemoveTypeFromUnusedPatternCheck.typeIsMissing(pat.patternVariable())) continue;
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)pat.patternVariable()).withMessage("Remove unused type from unnamed pattern").withQuickFix(() -> RemoveTypeFromUnusedPatternCheck.getQuickFix(pat.patternVariable().type())).report();
        }
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava22Compatible();
    }

    private static JavaQuickFix getQuickFix(TypeTree tree) {
        return JavaQuickFix.newQuickFix((String)"Remove unused type").addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTree((Tree)tree)}).build();
    }

    private static boolean typeIsMissing(VariableTree v) {
        return v.type() instanceof InferedTypeTree;
    }
}

