/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S7467")
public class ReplaceUnusedExceptionParameterWithUnnamedPatternCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.CATCH);
    }

    public void visitNode(Tree tree) {
        CatchTree catchTree = (CatchTree)tree;
        VariableTree v = catchTree.parameter();
        IdentifierTree ident = v.simpleName();
        if (!ident.isUnnamedVariable() && v.symbol().usages().isEmpty()) {
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)ident).withMessage(String.format("Replace \"%s\" with an unnamed pattern.", ident.name())).withQuickFix(() -> ReplaceUnusedExceptionParameterWithUnnamedPatternCheck.getQuickFix(ident)).report();
        }
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava22Compatible();
    }

    private static JavaQuickFix getQuickFix(IdentifierTree ident) {
        return JavaQuickFix.newQuickFix((String)String.format("Replace \"%s\" with unnamed pattern \"_\"", ident.name())).addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)ident, (String)"_")}).build();
    }
}

