/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2151")
public class RunFinalizersCheck
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"java.lang.Runtime", "java.lang.System"}).names(new String[]{"runFinalizersOnExit"}).addParametersMatcher(new String[]{"boolean"}).build();
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Remove this call to \"" + mit.methodSymbol().owner().name() + ".runFinalizersOnExit()\".");
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isNotSet() || version.asInt() < 11;
    }
}

