/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2129")
public class StringPrimitiveConstructorCheck
extends IssuableSubscriptionVisitor {
    private static final String QUICK_FIX_MESSAGE = "Replace this \"%s\" constructor with %s";
    private static final String REPLACEMENT_MESSAGE = "the %s literal passed as parameter";
    private static final String ISSUE_MESSAGE = "Remove this \"%s\" constructor";
    private static final String STRING = "java.lang.String";
    private static final BigInteger MIN_BIG_INTEGER_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger MAX_BIG_INTEGER_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private static final MethodMatchers EMPTY_STRING_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).constructor().addWithoutParametersMatcher().build();
    private static final MethodMatchers BIG_INT_MATCHER = StringPrimitiveConstructorCheck.primitiveConstructorMatcher("java.math.BigInteger", "java.lang.String");
    private static final MethodMatchers matchers = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{EMPTY_STRING_MATCHER, BIG_INT_MATCHER, StringPrimitiveConstructorCheck.primitiveConstructorMatcher("java.lang.String", "java.lang.String"), StringPrimitiveConstructorCheck.primitiveConstructorMatcher("java.lang.Byte", "byte"), StringPrimitiveConstructorCheck.primitiveConstructorMatcher("java.lang.Character", "char"), StringPrimitiveConstructorCheck.primitiveConstructorMatcher("java.lang.Short", "short"), StringPrimitiveConstructorCheck.primitiveConstructorMatcher("java.lang.Integer", "int"), StringPrimitiveConstructorCheck.primitiveConstructorMatcher("java.lang.Long", "long"), StringPrimitiveConstructorCheck.primitiveConstructorMatcher("java.lang.Float", "float"), StringPrimitiveConstructorCheck.primitiveConstructorMatcher("java.lang.Double", "double"), StringPrimitiveConstructorCheck.primitiveConstructorMatcher("java.lang.Boolean", "boolean")});
    private static final Map<String, String> classToLiteral = Map.of("String", "string", "Double", "double", "Integer", "int", "Boolean", "boolean", "Byte", "byte", "Character", "char", "Short", "short", "Long", "long", "Float", "float");

    private static MethodMatchers primitiveConstructorMatcher(String constructor, String param) {
        return MethodMatchers.create().ofTypes(new String[]{constructor}).constructor().addParametersMatcher(new String[]{param}).build();
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        NewClassTree newClassTree = (NewClassTree)tree;
        if (newClassTree.classBody() != null) {
            return;
        }
        if (StringPrimitiveConstructorCheck.isBigIntegerPotentiallyBiggerThanLong(newClassTree)) {
            return;
        }
        if (newClassTree.arguments().stream().anyMatch(arg -> arg.symbolType().isUnknown())) {
            return;
        }
        if (matchers.matches(newClassTree)) {
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)newClassTree.identifier()).withMessage(ISSUE_MESSAGE, new Object[]{newClassTree.symbolType().name()}).withQuickFix(() -> this.computeQuickFix(newClassTree)).report();
        }
    }

    private static boolean isBigIntegerPotentiallyBiggerThanLong(NewClassTree newClassTree) {
        if (!newClassTree.symbolType().is("java.math.BigInteger")) {
            return false;
        }
        ExpressionTree argument = (ExpressionTree)newClassTree.arguments().get(0);
        if (!argument.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return true;
        }
        try {
            BigInteger value = new BigInteger(LiteralUtils.trimQuotes((String)((LiteralTree)argument).value()));
            return value.compareTo(MIN_BIG_INTEGER_VALUE) < 0 || value.compareTo(MAX_BIG_INTEGER_VALUE) > 0;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    private JavaQuickFix computeQuickFix(NewClassTree newClassTree) {
        JavaTextEdit textEdit;
        String message;
        String className = newClassTree.symbolType().name();
        if (EMPTY_STRING_MATCHER.matches(newClassTree)) {
            message = StringPrimitiveConstructorCheck.formatQuickFixMessage(className, "an empty string \"\"");
            textEdit = JavaTextEdit.replaceTree((Tree)newClassTree, (String)"\"\"");
        } else if (BIG_INT_MATCHER.matches(newClassTree)) {
            String arg = this.getFirstArgumentAsString(newClassTree).replace("\"", "") + "L";
            String replacement = String.format("BigInteger.valueOf(%s)", arg);
            message = StringPrimitiveConstructorCheck.formatQuickFixMessage(className, "\"BigInteger.valueOf()\" static method");
            textEdit = JavaTextEdit.replaceTree((Tree)newClassTree, (String)replacement);
        } else {
            message = StringPrimitiveConstructorCheck.formatQuickFixMessage(className, String.format(REPLACEMENT_MESSAGE, classToLiteral.get(className)));
            String replacement = this.getFirstArgumentAsString(newClassTree);
            textEdit = JavaTextEdit.replaceTree((Tree)newClassTree, (String)replacement);
        }
        return JavaQuickFix.newQuickFix((String)message).addTextEdit(new JavaTextEdit[]{textEdit}).build();
    }

    private static String formatQuickFixMessage(String constructor, String replacement) {
        return String.format(QUICK_FIX_MESSAGE, constructor, replacement);
    }

    private String getFirstArgumentAsString(NewClassTree newClassTree) {
        ExpressionTree expr = (ExpressionTree)newClassTree.arguments().get(0);
        return QuickFixHelper.contentForTree((Tree)expr, this.context);
    }
}

