/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2225")
public class ToStringReturningNullCheck
extends IssuableSubscriptionVisitor {
    private String interestingMethodName = null;
    private int nestedLambdas = 0;

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.RETURN_STATEMENT, Tree.Kind.LAMBDA_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        ExpressionTree rawReturnExpression;
        ExpressionTree returnExpression;
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.interestingMethodName = ToStringReturningNullCheck.interestingMethodName((MethodTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.LAMBDA_EXPRESSION})) {
            ++this.nestedLambdas;
        } else if (this.interestingMethodName != null && this.nestedLambdas == 0 && (returnExpression = ExpressionUtils.skipParentheses((ExpressionTree)(rawReturnExpression = ((ReturnStatementTree)tree).expression()))).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
            boolean isToString = "toString".equals(this.interestingMethodName);
            InternalJavaIssueBuilder builder = QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)returnExpression).withMessage(isToString ? "Return empty string instead." : "Return a non null object.");
            if (isToString) {
                builder.withQuickFix(() -> ToStringReturningNullCheck.computeQuickFix(rawReturnExpression));
            }
            builder.report();
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.interestingMethodName = null;
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.LAMBDA_EXPRESSION})) {
            --this.nestedLambdas;
        }
    }

    private static String interestingMethodName(MethodTree method) {
        String methodName = method.simpleName().name();
        if (method.parameters().isEmpty() && ("toString".equals(methodName) || "clone".equals(methodName))) {
            return methodName;
        }
        return null;
    }

    private static JavaQuickFix computeQuickFix(ExpressionTree rawReturnExpression) {
        return JavaQuickFix.newQuickFix((String)"Replace null with an empty string").addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)rawReturnExpression, (String)"\"\"")}).build();
    }
}

