/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.AnnotationsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="S00107", repositoryKey="squid")
@Rule(key="S107")
public class TooManyParametersCheck
extends IssuableSubscriptionVisitor {
    private static final Tree.Kind[] METHOD_AND_CONSTRUCTOR = new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR};
    private static final Tree.Kind[] METHOD_ONLY = new Tree.Kind[]{Tree.Kind.METHOD};
    private static final int DEFAULT_MAXIMUM = 7;
    @RuleProperty(key="max", description="Maximum authorized number of parameters", defaultValue="7")
    public int maximum = 7;
    @RuleProperty(key="constructorMax", description="Maximum authorized number of parameters for a constructor", defaultValue="7")
    public int constructorMax = 7;
    private static final List<String> METHOD_ANNOTATION_EXCEPTIONS = Arrays.asList("com.fasterxml.jackson.annotation.JsonCreator", "javax.ws.rs.GET", "javax.ws.rs.POST", "javax.ws.rs.PUT", "javax.ws.rs.PATCH", "javax.inject.Inject", "jakarta.ws.rs.GET", "jakarta.ws.rs.POST", "jakarta.ws.rs.PUT", "jakarta.ws.rs.PATCH", "jakarta.inject.Inject", "lombok.Builder", "io.micronaut.http.annotation.Get", "io.micronaut.http.annotation.Post", "io.micronaut.http.annotation.Put", "io.micronaut.http.annotation.Delete", "io.micronaut.http.annotation.Options", "io.micronaut.http.annotation.Patch", "io.micronaut.http.annotation.Head", "io.micronaut.http.annotation.Trace", "org.springframework.beans.factory.annotation.Autowired");

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        Tree.Kind[] membersToVisit = TooManyParametersCheck.membersToVisit(classTree);
        classTree.members().stream().filter(member -> member.is(membersToVisit)).forEach(member -> this.visitMethod((MethodTree)member));
    }

    private void visitMethod(MethodTree method) {
        String partialMessage;
        int max;
        if (TooManyParametersCheck.isOverriding(method) || TooManyParametersCheck.usesAuthorizedAnnotation(method)) {
            return;
        }
        if (method.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
            max = this.constructorMax;
            partialMessage = "Constructor";
        } else {
            max = this.maximum;
            partialMessage = "Method";
        }
        int size = method.parameters().size();
        if (size > max) {
            this.reportIssue((Tree)method.simpleName(), partialMessage + " has " + size + " parameters, which is greater than " + max + " authorized.");
        }
    }

    private static boolean isOverriding(MethodTree tree) {
        return !Boolean.FALSE.equals(tree.isOverriding());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean usesAuthorizedAnnotation(MethodTree method) {
        SymbolMetadata metadata = method.symbol().metadata();
        if (AnnotationsHelper.hasUnknownAnnotation(metadata)) return true;
        if (!METHOD_ANNOTATION_EXCEPTIONS.stream().anyMatch(arg_0 -> ((SymbolMetadata)metadata).isAnnotatedWith(arg_0))) return false;
        return true;
    }

    private static Tree.Kind[] membersToVisit(ClassTree methodParentClass) {
        long numberOfConstructors;
        SymbolMetadata parentClassMetadata = methodParentClass.symbol().metadata();
        if (AnnotationsHelper.hasUnknownAnnotation(parentClassMetadata) && (numberOfConstructors = methodParentClass.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})).count()) == 1L) {
            return METHOD_ONLY;
        }
        return METHOD_AND_CONSTRUCTOR;
    }
}

