/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VarTypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S7466")
public class UnnamedVariableShouldUseVarCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.FOR_EACH_STATEMENT, Tree.Kind.TRY_STATEMENT);
    }

    public void visitNode(Tree tree) {
        if (tree instanceof ForEachStatement) {
            ForEachStatement forEachTree = (ForEachStatement)tree;
            this.checkVariable(forEachTree.variable());
        } else if (tree instanceof TryStatementTree) {
            TryStatementTree tryTree = (TryStatementTree)tree;
            for (Tree resource : tryTree.resourceList()) {
                if (!(resource instanceof VariableTree)) continue;
                VariableTree variable = (VariableTree)resource;
                this.checkVariable(variable);
            }
        }
    }

    void checkVariable(VariableTree variable) {
        TypeTree type = variable.type();
        if (variable.simpleName().isUnnamedVariable() && !UnnamedVariableShouldUseVarCheck.isVarDeclaration(type)) {
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)type).withMessage("Use `var` instead of a type with unnamed variable _").withQuickFix(() -> UnnamedVariableShouldUseVarCheck.getQuickFix(type)).report();
        }
    }

    private static boolean isVarDeclaration(TypeTree typeTree) {
        return typeTree instanceof VarTypeTree;
    }

    private static JavaQuickFix getQuickFix(TypeTree tree) {
        return JavaQuickFix.newQuickFix((String)"Replace the type with \"var\"").addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)tree, (String)"var")}).build();
    }
}

