/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.JProblem;
import org.sonar.java.model.JWarning;
import org.sonar.java.model.JavaTree;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="UselessImportCheck", repositoryKey="squid")
@Rule(key="S1128")
public class UselessImportCheck
extends IssuableSubscriptionVisitor {
    private static final Pattern COMPILER_WARNING = Pattern.compile("The import ([$\\w]++(\\.[$\\w]++)*+) is never used");
    private static final Pattern NON_WORDS_CHARACTERS = Pattern.compile("\\W+");
    private static final Pattern JAVADOC_REFERENCE = Pattern.compile("\\{@link[^\\{\\}]++\\}|(@see|@throws)[^\r\n]++[\r\n]");
    private static final Pattern MARKDOWN_REFERENCE = Pattern.compile("\\[[^\\[\\]\\r\\n]++\\]");
    private String currentPackage = "";
    private final List<ImportTree> imports = new ArrayList<ImportTree>();
    private final Map<String, String> importsNames = new HashMap<String, String>();
    private final Set<String> duplicatedImports = new HashSet<String>();
    private final Set<String> usedInJavaDoc = new HashSet<String>();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.TRIVIA, Tree.Kind.COMPILATION_UNIT, Tree.Kind.PACKAGE, Tree.Kind.IMPORT);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT})) {
            ((CompilationUnitTree)tree).imports().stream().filter(importTree -> importTree.is(new Tree.Kind[]{Tree.Kind.IMPORT})).map(ImportTree.class::cast).forEach(this.imports::add);
            this.importsNames.clear();
            this.duplicatedImports.clear();
            this.usedInJavaDoc.clear();
            this.currentPackage = "";
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.PACKAGE})) {
            this.currentPackage = ExpressionsHelper.concatenate((ExpressionTree)((PackageDeclarationTree)tree).packageName());
        } else {
            this.handleImportTree((ImportTree)tree);
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT})) {
            this.handleWarnings(((JavaTree.CompilationUnitTreeImpl)tree).warnings(JProblem.Type.UNUSED_IMPORT));
            this.imports.clear();
        }
    }

    private void handleWarnings(List<JWarning> warnings) {
        for (JWarning warning : warnings) {
            Matcher matcher = COMPILER_WARNING.matcher(warning.message());
            Optional<String> fqn = matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
            fqn.ifPresent(importName -> {
                if (!this.usedInJavaDoc.contains(importName) && !importName.startsWith("java.lang")) {
                    Object message = this.duplicatedImports.contains(importName) ? "Remove this duplicated import." : (this.isImportFromSamePackage((String)importName, warning.syntaxTree()) ? "Remove this unnecessary import: same package classes are always implicitly imported." : "Remove this unused import '" + importName + "'.");
                    ImportTree reportTree = (ImportTree)warning.syntaxTree();
                    QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree(reportTree.qualifiedIdentifier()).withMessage((String)message).withQuickFix(() -> UselessImportCheck.quickFix(reportTree, this.imports)).report();
                }
            });
        }
    }

    private boolean isImportFromSamePackage(String importName, Tree tree) {
        Tree qualifiedIdentifier;
        if (tree.is(new Tree.Kind[]{Tree.Kind.IMPORT}) && (qualifiedIdentifier = ((ImportTree)tree).qualifiedIdentifier()).is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && "*".equals(((MemberSelectExpressionTree)qualifiedIdentifier).identifier().name())) {
            return importName.equals(this.currentPackage);
        }
        return importName.substring(0, importName.lastIndexOf(".")).equals(this.currentPackage);
    }

    private void handleImportTree(ImportTree importTree) {
        String importName = ExpressionsHelper.concatenate((ExpressionTree)((ExpressionTree)importTree.qualifiedIdentifier()));
        if (this.importsNames.containsKey(importName)) {
            this.duplicatedImports.add(importName);
        } else {
            this.importsNames.put(importName, UselessImportCheck.extractLastClassName(importName));
        }
        if (UselessImportCheck.isJavaLangImport(importName)) {
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree(importTree.qualifiedIdentifier()).withMessage("Remove this unnecessary import: java.lang classes are always implicitly imported.").withQuickFix(() -> UselessImportCheck.quickFix(importTree, this.imports)).report();
        }
    }

    private static String extractLastClassName(String reference) {
        int lastIndexOfDot = reference.lastIndexOf(46);
        return lastIndexOfDot == -1 ? reference : reference.substring(lastIndexOfDot + 1);
    }

    private static boolean isJavaLangImport(String reference) {
        return reference.startsWith("java.lang.") && reference.indexOf(46, "java.lang.".length()) == -1;
    }

    public void visitTrivia(SyntaxTrivia syntaxTrivia) {
        Matcher matcher;
        String comment = syntaxTrivia.comment();
        if (syntaxTrivia.isComment(SyntaxTrivia.CommentKind.JAVADOC)) {
            matcher = JAVADOC_REFERENCE.matcher(comment);
        } else if (syntaxTrivia.isComment(SyntaxTrivia.CommentKind.MARKDOWN)) {
            matcher = MARKDOWN_REFERENCE.matcher(comment);
        } else {
            return;
        }
        while (matcher.find()) {
            String line = matcher.group(0);
            Set words = NON_WORDS_CHARACTERS.splitAsStream(line).filter(w -> !w.isEmpty()).collect(Collectors.toSet());
            if (words.isEmpty()) continue;
            this.importsNames.forEach((fullyQualifiedName, name) -> {
                if (words.contains(name)) {
                    this.usedInJavaDoc.add((String)fullyQualifiedName);
                }
            });
        }
    }

    private static JavaQuickFix quickFix(ImportTree importTree, List<ImportTree> imports) {
        int indexOfImport = imports.indexOf(importTree);
        boolean isLastImport = indexOfImport == imports.size() - 1;
        JavaQuickFix.Builder quickFix = JavaQuickFix.newQuickFix((String)"Remove the %simport", (Object[])new Object[]{importTree.isStatic() ? "static " : ""});
        if (imports.size() == 1) {
            quickFix.addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTree((Tree)importTree)});
        } else if (!isLastImport) {
            ImportTree nextImport = imports.get(indexOfImport + 1);
            quickFix.addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)importTree, (boolean)true, (Tree)nextImport, (boolean)false))});
        } else {
            ImportTree previousImport = imports.get(indexOfImport - 1);
            quickFix.addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)previousImport, (boolean)false, (Tree)importTree, (boolean)true))});
        }
        return quickFix.build();
    }
}

