/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1941")
public class VariableDeclarationScopeCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.BLOCK);
    }

    public void visitNode(Tree tree) {
        BlockTree block = (BlockTree)tree;
        List body = block.body();
        int bodySize = body.size();
        for (int i = 0; i < bodySize; ++i) {
            VariableTree variableTree;
            StatementTree statement = (StatementTree)body.get(i);
            if (!statement.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || (variableTree = (VariableTree)statement).symbol().usages().isEmpty()) continue;
            this.check(variableTree, body, bodySize, i + 1);
        }
    }

    private void check(VariableTree variable, List<StatementTree> body, int bodySize, int next) {
        Symbol symbol = variable.symbol();
        ReferenceVisitor referenceVisitor = new ReferenceVisitor(symbol);
        for (int i = next; i < bodySize; ++i) {
            referenceVisitor.visit(body.get(i));
            if (referenceVisitor.referencesSymbol) {
                return;
            }
            if (!referenceVisitor.hasBreakingStatement) continue;
            this.reportIssue((Tree)variable.simpleName(), "Move the declaration of \"" + symbol.name() + "\" closer to the code that uses it.");
            return;
        }
    }

    private static class ReferenceVisitor
    extends BaseTreeVisitor {
        private final Symbol symbol;
        boolean referencesSymbol;
        boolean hasBreakingStatement;

        ReferenceVisitor(Symbol symbol) {
            this.symbol = symbol;
        }

        void visit(StatementTree node) {
            this.referencesSymbol = false;
            this.hasBreakingStatement = false;
            node.accept((TreeVisitor)this);
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            this.hasBreakingStatement = true;
            super.visitReturnStatement(tree);
        }

        public void visitThrowStatement(ThrowStatementTree tree) {
            this.hasBreakingStatement = true;
            super.visitThrowStatement(tree);
        }

        public void visitIdentifier(IdentifierTree tree) {
            this.referencesSymbol |= this.symbol.equals((Object)tree.symbol());
            this.referencesSymbol |= tree.symbol().isUnknown() && this.symbol.name().equals(tree.name());
            super.visitIdentifier(tree);
        }
    }
}

