/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class UnresolvedIdentifiersVisitor
extends BaseTreeVisitor {
    private final Set<String> unresolvedIdentifierNames = new HashSet<String>();

    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        this.scan((Tree)tree.expression());
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        ExpressionTree methodSelect = tree.methodSelect();
        if (!methodSelect.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.scan((Tree)methodSelect);
        }
        this.scan((ListTree)tree.typeArguments());
        this.scan((ListTree)tree.arguments());
    }

    public void visitIdentifier(IdentifierTree tree) {
        if (tree.symbol().isUnknown()) {
            this.unresolvedIdentifierNames.add(tree.name());
        }
        super.visitIdentifier(tree);
    }

    public Set<String> check(Tree tree) {
        this.unresolvedIdentifierNames.clear();
        tree.accept((TreeVisitor)this);
        return this.unresolvedNames();
    }

    public Set<String> check(List<? extends Tree> trees) {
        this.unresolvedIdentifierNames.clear();
        trees.forEach(tree -> tree.accept((TreeVisitor)this));
        return this.unresolvedNames();
    }

    private Set<String> unresolvedNames() {
        return Collections.unmodifiableSet(this.unresolvedIdentifierNames);
    }

    public boolean isUnresolved(String candidate) {
        return this.unresolvedIdentifierNames.contains(candidate);
    }
}

