/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="S00117", repositoryKey="squid")
@Rule(key="S117")
public class BadLocalVariableNameCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String DEFAULT_FORMAT = "^[a-z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", description="Regular expression used to check the names against.", defaultValue="^[a-z][a-zA-Z0-9]*$")
    public String format = "^[a-z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        for (Tree member : tree.members()) {
            if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                this.scan((Tree)((VariableTree)member).initializer());
                continue;
            }
            this.scan(member);
        }
    }

    public void visitForStatement(ForStatementTree tree) {
        this.scan((Tree)tree.statement());
    }

    public void visitForEachStatement(ForEachStatement tree) {
        this.scan((Tree)tree.statement());
    }

    public void visitCatch(CatchTree tree) {
        VariableTree parameter = tree.parameter();
        if (parameter.simpleName().name().length() > 1) {
            this.scan((Tree)parameter);
        }
        this.scan((Tree)tree.block());
    }

    public void visitVariable(VariableTree tree) {
        IdentifierTree simpleName = tree.simpleName();
        if (!(simpleName.isUnnamedVariable() || this.pattern.matcher(simpleName.name()).matches() || this.isLocalConstant(tree))) {
            this.context.reportIssue((JavaCheck)this, (Tree)simpleName, "Rename this local variable to match the regular expression '" + this.format + "'.");
        }
        super.visitVariable(tree);
    }

    private boolean isLocalConstant(VariableTree tree) {
        return this.context.getSemanticModel() != null && BadLocalVariableNameCheck.isConstantType(tree.symbol().type()) && tree.symbol().isFinal();
    }

    private static boolean isConstantType(Type symbolType) {
        return symbolType.isPrimitive() || symbolType.is("java.lang.String") || symbolType.isPrimitiveWrapper();
    }
}

