/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import org.sonar.check.Rule;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.regex.RegexCheck;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.finders.UnicodeUnawareCharClassFinder;

@Rule(key="S5867")
public class UnicodeAwareCharClassesCheck
extends AbstractRegexCheck {
    @Override
    public void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation) {
        new UnicodeUnawareCharClassFinder(this::reportIssueFromCommons, (message, cost, secondaries) -> {
            String flagName = methodInvocationOrAnnotation.is(new Tree.Kind[]{Tree.Kind.ANNOTATION}) ? "(?U)" : "UNICODE_CHARACTER_CLASS";
            this.reportIssue(this.methodOrAnnotationName(methodInvocationOrAnnotation), message.replace("\"u\"", String.format("\"%s\"", flagName)), cost, secondaries.stream().map(RegexCheck.RegexIssueLocation::fromCommonsRegexIssueLocation).toList());
        }).visit(regexForLiterals);
    }
}

