/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S7435")
public class AndroidPersistentUniqueIdentifierCheck
extends AbstractMethodDetection {
    private static final String HARDWARE_ID_MESSAGE = "Using a hardware identifier puts user privacy at risk. Make sure it is safe here.";
    private static final String PHONE_NUMBER_MESSAGE = "Using a phone number puts user privacy at risk. Make sure it is safe here.";
    private static final String ADVERTISING_ID_MESSAGE = "Using Advertising ID puts user privacy at risk. Make sure it is safe here.";
    private static final String NON_RESETTABLE_PERSISTENT_ID_MESSAGE = "Using a non-resettable persistent identifier puts user privacy at risk. Make sure it is safe here.";
    private static final MethodMatchers STATIC_SETTINGS_SECURE_GET_STRING_MATCHER = MethodMatchers.create().ofTypes(new String[]{"android.provider.Settings$Secure"}).names(new String[]{"getString"}).addParametersMatcher(new String[]{"android.content.ContentResolver", "java.lang.String"}).build();
    private static final Map<MethodMatchers, String> MATCHERS = Map.of(MethodMatchers.create().ofTypes(new String[]{"android.bluetooth.BluetoothAdapter"}).names(new String[]{"getAddress"}).withAnyParameters().build(), "Using a hardware identifier puts user privacy at risk. Make sure it is safe here.", MethodMatchers.create().ofSubTypes(new String[]{"android.net.wifi.WifiInfo"}).names(new String[]{"getMacAddress"}).withAnyParameters().build(), "Using a hardware identifier puts user privacy at risk. Make sure it is safe here.", MethodMatchers.create().ofSubTypes(new String[]{"android.telephony.TelephonyManager"}).names(new String[]{"getSimSerialNumber", "getDeviceId", "getImei", "getMeid"}).withAnyParameters().build(), "Using a hardware identifier puts user privacy at risk. Make sure it is safe here.", MethodMatchers.create().ofSubTypes(new String[]{"android.telephony.TelephonyManager"}).names(new String[]{"getLine1Number"}).withAnyParameters().build(), "Using a phone number puts user privacy at risk. Make sure it is safe here.", MethodMatchers.create().ofSubTypes(new String[]{"android.telephony.SubscriptionManager"}).names(new String[]{"getPhoneNumber"}).withAnyParameters().build(), "Using a phone number puts user privacy at risk. Make sure it is safe here.", MethodMatchers.create().ofSubTypes(new String[]{"com.google.android.gms.ads.identifier.AdvertisingIdClient$Info", "androidx.ads.identifier.AdvertisingIdInfo", "com.huawei.hms.ads.identifier.AdvertisingIdClient$Info"}).names(new String[]{"getId"}).withAnyParameters().build(), "Using Advertising ID puts user privacy at risk. Make sure it is safe here.", STATIC_SETTINGS_SECURE_GET_STRING_MATCHER, "Using a non-resettable persistent identifier puts user privacy at risk. Make sure it is safe here.");
    private static final MethodMatchers ALL_MATCHER = MethodMatchers.or((MethodMatchers[])((MethodMatchers[])MATCHERS.keySet().toArray(MethodMatchers[]::new)));

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD_INVOCATION, Tree.Kind.METHOD_REFERENCE);
    }

    protected MethodMatchers getMethodInvocationMatchers() {
        return ALL_MATCHER;
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        MATCHERS.keySet().stream().filter(matcher -> AndroidPersistentUniqueIdentifierCheck.isInvocationCandidate(matcher, mit)).findFirst().ifPresent(matcher -> {
            ExpressionTree expressionTree;
            ExpressionTree patt0$temp = mit.methodSelect();
            if (patt0$temp instanceof MemberSelectExpressionTree) {
                MemberSelectExpressionTree mset = (MemberSelectExpressionTree)patt0$temp;
                expressionTree = mset.identifier();
            } else {
                expressionTree = mit.methodSelect();
            }
            ExpressionTree tree = expressionTree;
            String message = MATCHERS.get(matcher);
            this.reportIssue((Tree)tree, message);
        });
    }

    protected void onMethodReferenceFound(MethodReferenceTree methodReferenceTree) {
        MATCHERS.keySet().stream().filter(matcher -> AndroidPersistentUniqueIdentifierCheck.isReferenceCandidate(matcher, methodReferenceTree)).findFirst().ifPresent(matcher -> this.reportIssue((Tree)methodReferenceTree.method(), MATCHERS.get(matcher)));
    }

    private static boolean isInvocationCandidate(MethodMatchers matcher, MethodInvocationTree mit) {
        return matcher.matches(mit) && (matcher != STATIC_SETTINGS_SECURE_GET_STRING_MATCHER || AndroidPersistentUniqueIdentifierCheck.hasAndroidIdArgument(mit));
    }

    private static boolean isReferenceCandidate(MethodMatchers matcher, MethodReferenceTree methodReferenceTree) {
        return matcher.matches(methodReferenceTree) && matcher != STATIC_SETTINGS_SECURE_GET_STRING_MATCHER;
    }

    private static boolean hasAndroidIdArgument(MethodInvocationTree mit) {
        return ((ExpressionTree)mit.arguments().get(1)).asConstant().map("android_id"::equals).orElse(false);
    }
}

