/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S5344")
public class PasswordEncoderCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVAX_CRYPTO_MESSAGE_FORMAT = "Use at least %d PBKDF2 iterations.";
    private static final Map<String, Integer> MIN_ITERATIONS_BY_ALGORITHM = Map.of("PBKDF2withHmacSHA1", 1300000, "PBKDF2withHmacSHA256", 600000, "PBKDF2withHmacSHA512", 210000);
    private static final MethodMatchers JDBC_AUTHENTICATION = MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder"}).names(new String[]{"jdbcAuthentication"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers USER_DETAIL_SERVICE = MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder"}).names(new String[]{"userDetailsService"}).withAnyParameters().build();
    private static final MethodMatchers PASSWORD_ENCODER_SETTER = MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.security.config.annotation.authentication.configurers.userdetails.AbstractDaoAuthenticationConfigurer"}).names(new String[]{"passwordEncoder"}).withAnyParameters().build();
    private static final MethodMatchers UNSAFE_PASSWORD_ENCODER_CONSTRUCTORS = MethodMatchers.create().ofTypes(new String[]{"org.springframework.security.authentication.encoding.ShaPasswordEncoder", "org.springframework.security.authentication.encoding.Md5PasswordEncoder", "org.springframework.security.crypto.password.LdapShaPasswordEncoder", "org.springframework.security.crypto.password.Md4PasswordEncoder", "org.springframework.security.crypto.password.MessageDigestPasswordEncoder", "org.springframework.security.crypto.password.StandardPasswordEncoder", "org.springframework.security.crypto.scrypt.SCryptPasswordEncoder"}).constructor().withAnyParameters().build();
    private static final MethodMatchers UNSAFE_PASSWORD_ENCODER_METHODS = MethodMatchers.create().ofTypes(new String[]{"org.springframework.security.crypto.password.NoOpPasswordEncoder"}).names(new String[]{"getInstance"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers SECRET_KEY_FACTORY_GENERATE_SECRET_METHOD = MethodMatchers.create().ofTypes(new String[]{"javax.crypto.SecretKeyFactory"}).names(new String[]{"generateSecret"}).addParametersMatcher(new String[]{"java.security.spec.KeySpec"}).build();
    private static final MethodMatchers SECRET_KEY_FACTORY_GET_INSTANCE_METHOD = MethodMatchers.create().ofTypes(new String[]{"javax.crypto.SecretKeyFactory"}).names(new String[]{"getInstance"}).addParametersMatcher(new String[]{"java.lang.String"}).build();
    private static final MethodMatchers PBE_KEY_SPEC_CONSTRUCTOR = MethodMatchers.create().ofTypes(new String[]{"javax.crypto.spec.PBEKeySpec"}).constructor().addParametersMatcher(new String[]{"char[]", "byte[]", "int"}).addParametersMatcher(new String[]{"char[]", "byte[]", "int", "int"}).build();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.NEW_CLASS, Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree mit;
        MethodInvocationTree mit2;
        NewClassTree nct;
        if (tree instanceof NewClassTree && UNSAFE_PASSWORD_ENCODER_CONSTRUCTORS.matches(nct = (NewClassTree)tree)) {
            this.reportIssue((Tree)nct.identifier(), "Use secure \"PasswordEncoder\" implementation.");
        } else if (tree instanceof MethodInvocationTree && UNSAFE_PASSWORD_ENCODER_METHODS.matches(mit2 = (MethodInvocationTree)tree)) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit2), "Use secure \"PasswordEncoder\" implementation.");
        } else if (tree instanceof MethodInvocationTree && SECRET_KEY_FACTORY_GENERATE_SECRET_METHOD.matches(mit = (MethodInvocationTree)tree)) {
            this.checkJavaxCrypto(mit);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            MethodInvocationVisitor visitor = new MethodInvocationVisitor();
            tree.accept((TreeVisitor)visitor);
            if (visitor.hasAuthentication && !visitor.setsPasswordEncoder) {
                this.reportIssue((Tree)visitor.tree, "Don't use the default \"PasswordEncoder\" relying on plain-text.");
            }
        }
    }

    private void checkJavaxCrypto(MethodInvocationTree mit) {
        Optional algorithmValueExpressionAndValue = Optional.of(mit.methodSelect()).filter(e -> e.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})).map(MemberSelectExpressionTree.class::cast).map(MemberSelectExpressionTree::expression).flatMap(PasswordEncoderCheck::extractAlgorithm);
        if (algorithmValueExpressionAndValue.isEmpty()) {
            return;
        }
        ExpressionTree algorithmValueExpression = ((ExpressionsAndValue)algorithmValueExpressionAndValue.get()).initializerExpression();
        String algorithm = (String)((ExpressionsAndValue)algorithmValueExpressionAndValue.get()).value();
        if (!MIN_ITERATIONS_BY_ALGORITHM.containsKey(algorithm)) {
            return;
        }
        Optional<ExpressionsAndValue<Integer>> iterationCountExpressionsAndValue = PasswordEncoderCheck.extractIterationCount((ExpressionTree)mit.arguments().get(0));
        if (iterationCountExpressionsAndValue.isEmpty()) {
            return;
        }
        ExpressionTree iterationCountExpression = iterationCountExpressionsAndValue.get().expression();
        ExpressionTree iterationCountValueExpression = iterationCountExpressionsAndValue.get().initializerExpression();
        Integer iterationCount = iterationCountExpressionsAndValue.get().value();
        Integer minIteration = MIN_ITERATIONS_BY_ALGORITHM.get(algorithm);
        if (iterationCount < minIteration) {
            ArrayList<JavaFileScannerContext.Location> secondaryLocations = new ArrayList<JavaFileScannerContext.Location>();
            secondaryLocations.add(new JavaFileScannerContext.Location("", (Tree)algorithmValueExpression));
            if (!Objects.equals(iterationCountValueExpression.firstToken(), iterationCountExpression.firstToken())) {
                secondaryLocations.add(new JavaFileScannerContext.Location("", (Tree)iterationCountValueExpression));
            }
            this.reportIssue((Tree)iterationCountExpression, JAVAX_CRYPTO_MESSAGE_FORMAT.formatted(minIteration), secondaryLocations, null);
        }
    }

    private static Optional<ExpressionsAndValue<Integer>> extractIterationCount(ExpressionTree keySpecArgumentExpression) {
        return PasswordEncoderCheck.getInitializerIfExpressionIsVariableIdentifier(keySpecArgumentExpression).or(() -> Optional.of(keySpecArgumentExpression)).filter(e -> e.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})).map(NewClassTree.class::cast).filter(arg_0 -> ((MethodMatchers)PBE_KEY_SPEC_CONSTRUCTOR).matches(arg_0)).map(gi -> (ExpressionTree)gi.arguments().get(2)).flatMap(e -> PasswordEncoderCheck.getValueIfExpressionIsVariableIdentifier(e, Integer.class));
    }

    private static Optional<ExpressionsAndValue<String>> extractAlgorithm(ExpressionTree secretKeyFactoryExpression) {
        return PasswordEncoderCheck.getInitializerIfExpressionIsVariableIdentifier(secretKeyFactoryExpression).or(() -> Optional.of(secretKeyFactoryExpression)).filter(e -> e.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})).map(MethodInvocationTree.class::cast).filter(arg_0 -> ((MethodMatchers)SECRET_KEY_FACTORY_GET_INSTANCE_METHOD).matches(arg_0)).map(gi -> (ExpressionTree)gi.arguments().get(0)).flatMap(e -> PasswordEncoderCheck.getValueIfExpressionIsVariableIdentifier(e, String.class));
    }

    private static <T> Optional<ExpressionsAndValue<T>> getValueIfExpressionIsVariableIdentifier(ExpressionTree expression, Class<T> type) {
        Optional<ExpressionTree> initializerExpression = PasswordEncoderCheck.getInitializerIfExpressionIsVariableIdentifier(expression);
        return initializerExpression.flatMap(e -> e.asConstant(type)).map(v -> new ExpressionsAndValue<Object>(expression, (ExpressionTree)initializerExpression.get(), v)).or(() -> expression.asConstant(type).map(t -> new ExpressionsAndValue<Object>(expression, expression, t)));
    }

    private static Optional<ExpressionTree> getInitializerIfExpressionIsVariableIdentifier(ExpressionTree expression) {
        return Optional.of(expression).filter(e -> e.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})).map(IdentifierTree.class::cast).map(IdentifierTree::symbol).map(Symbol::declaration).filter(e -> e.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(VariableTree.class::cast).map(VariableTree::initializer);
    }

    static class MethodInvocationVisitor
    extends BaseTreeVisitor {
        private boolean hasAuthentication;
        private boolean setsPasswordEncoder;
        private MethodInvocationTree tree;

        MethodInvocationVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (JDBC_AUTHENTICATION.matches(tree) || USER_DETAIL_SERVICE.matches(tree)) {
                this.hasAuthentication = true;
                this.tree = tree;
            }
            if (PASSWORD_ENCODER_SETTER.matches(tree)) {
                this.setsPasswordEncoder = true;
            }
            super.visitMethodInvocation(tree);
        }
    }

    private record ExpressionsAndValue<T>(ExpressionTree expression, ExpressionTree initializerExpression, T value) {
    }
}

