/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5804")
public class UserEnumerationCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Make sure allowing user enumeration is safe here.";
    private static final String ABSTRACT_USER_DETAILS_AUTHENTICATION_PROVIDER = "org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider";
    private static final String SPRING_SEC_LDAP_AUTHENTICATION_PROVIDER = "org.springframework.security.ldap.authentication.LdapAuthenticationProvider";
    private static final String USER_DETAILS_SERVICE = "org.springframework.security.core.userdetails.UserDetailsService";
    private static final String USERNAME_NOT_FOUND_EXCEPTION = "org.springframework.security.core.userdetails.UsernameNotFoundException";
    private static final String HIDE_USER_NOT_FOUND_EXCEPTIONS = "setHideUserNotFoundExceptions";
    private static final String LOAD_USER_BY_USERNAME = "loadUserByUsername";
    private static final String BOOLEAN = "boolean";
    private static final String STRING = "java.lang.String";
    private static final String THROWABLE = "java.lang.Throwable";
    private final Deque<MethodTree> stack = new ArrayDeque<MethodTree>();
    private static final MethodMatchers SET_HIDE_USER_MATCHER = MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider", "org.springframework.security.ldap.authentication.LdapAuthenticationProvider"}).names(new String[]{"setHideUserNotFoundExceptions"}).addParametersMatcher(new String[]{"boolean"}).build();
    private static final MethodMatchers LOAD_USER_MATCHER = MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.security.core.userdetails.UserDetailsService"}).names(new String[]{"loadUserByUsername"}).addParametersMatcher(new String[]{"java.lang.String"}).build();

    public void setContext(JavaFileScannerContext context) {
        super.setContext(context);
        this.stack.clear();
    }

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.CONSTRUCTOR, Tree.Kind.METHOD_INVOCATION, Tree.Kind.THROW_STATEMENT, Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (tree instanceof MethodTree) {
            MethodTree method = (MethodTree)tree;
            this.stack.push(method);
            return;
        }
        if (tree instanceof ThrowStatementTree) {
            ThrowStatementTree throwStatementTree = (ThrowStatementTree)tree;
            if (throwStatementTree.expression().symbolType().is(USERNAME_NOT_FOUND_EXCEPTION) && !this.isInsideLoadUserByUserName()) {
                this.reportIssue((Tree)throwStatementTree.expression(), MESSAGE);
            }
            return;
        }
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
        Arguments arguments = methodInvocationTree.arguments();
        if (arguments.isEmpty()) {
            return;
        }
        ExpressionTree firstArgument = (ExpressionTree)arguments.get(0);
        this.checkHiddenUserNotFoundException(methodInvocationTree, firstArgument);
        this.checkLoadUserArgUsedInExceptions(methodInvocationTree, firstArgument);
    }

    public void leaveNode(Tree tree) {
        if (tree instanceof MethodTree) {
            this.stack.pop();
        }
    }

    private void checkLoadUserArgUsedInExceptions(MethodInvocationTree methodInvocationTree, ExpressionTree expression) {
        if (LOAD_USER_MATCHER.matches(methodInvocationTree) && expression instanceof IdentifierTree) {
            IdentifierTree identifierTree = (IdentifierTree)expression;
            identifierTree.symbol().usages().stream().filter(UserEnumerationCheck::checkParentIsThrowable).forEach(value -> this.reportIssue((Tree)value, MESSAGE));
        }
    }

    private void checkHiddenUserNotFoundException(MethodInvocationTree methodInvocationTree, ExpressionTree expression) {
        if (SET_HIDE_USER_MATCHER.matches(methodInvocationTree) && !expression.asConstant(Boolean.class).orElse(true).booleanValue()) {
            this.reportIssue((Tree)methodInvocationTree, MESSAGE);
        }
    }

    private static boolean checkParentIsThrowable(Tree tree) {
        Tree current = tree.parent();
        while (current instanceof ExpressionTree || current instanceof Arguments) {
            NewClassTree newClassTree;
            if (current instanceof NewClassTree && (newClassTree = (NewClassTree)current).symbolType().isSubtypeOf(THROWABLE)) {
                return true;
            }
            current = current.parent();
        }
        return false;
    }

    private boolean isInsideLoadUserByUserName() {
        return LOAD_USER_MATCHER.matches(this.stack.peekFirst());
    }
}

