/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S7409")
public class WebViewJavaScriptInterfaceCheck
extends AbstractMethodDetection {
    private static final String MESSAGE = "Exposing a Javascript interface can expose sensitive information to attackers. Make sure it is safe here.";

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofSubTypes(new String[]{"android.webkit.WebView"}).names(new String[]{"addJavascriptInterface"}).addParametersMatcher(new String[]{"java.lang.Object", "java.lang.String"}).build();
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)mit, MESSAGE);
    }
}

