/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6809")
public class AsyncMethodsCalledViaThisCheck
extends IssuableSubscriptionVisitor {
    private static final Map<String, String> DISALLOWED_METHOD_ANNOTATIONS = Map.of("org.springframework.scheduling.annotation.Async", "async", "org.springframework.transaction.annotation.Transactional", "transactional", "org.springframework.cache.annotation.Cacheable", "cacheable");

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        if (!mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) || ExpressionUtils.isThis((ExpressionTree)((MemberSelectExpressionTree)mit.methodSelect()).expression())) {
            DISALLOWED_METHOD_ANNOTATIONS.entrySet().stream().filter(entry -> mit.methodSymbol().metadata().isAnnotatedWith((String)entry.getKey())).findFirst().map(Map.Entry::getValue).ifPresent(friendlyName -> this.reportIssue((Tree)mit, "Call " + friendlyName + " methods via an injected dependency instead of directly via 'this'."));
        }
    }
}

