/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S7180")
public class CacheAnnotationsShouldOnlyBeAppliedToConcreteClassesCheck
extends IssuableSubscriptionVisitor {
    private static final String ISSUE_MESSAGE = "\"@%s\" annotation should only be applied to concrete classes.";
    private static final String REPOSITORY_INTERFACE = "org.springframework.data.repository.Repository";
    private static final Set<String> CACHING_ANNOTATIONS = Set.of("org.springframework.cache.annotation.CacheConfig", "org.springframework.cache.annotation.CacheEvict", "org.springframework.cache.annotation.CachePut", "org.springframework.cache.annotation.Cacheable", "org.springframework.cache.annotation.Caching");

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.INTERFACE);
    }

    public void visitNode(Tree tree) {
        ClassTree anInterface = (ClassTree)tree;
        if (anInterface.symbol().type().isSubtypeOf(REPOSITORY_INTERFACE)) {
            return;
        }
        CacheAnnotationsShouldOnlyBeAppliedToConcreteClassesCheck.selectCachingAnnotations(anInterface.modifiers()).forEach(ann -> {
            String name = ann.symbolType().name();
            this.reportIssue((Tree)ann, String.format(ISSUE_MESSAGE, name));
        });
        Stream<MethodTree> methods = anInterface.members().stream().filter(MethodTree.class::isInstance).map(MethodTree.class::cast);
        methods.forEach(method -> CacheAnnotationsShouldOnlyBeAppliedToConcreteClassesCheck.selectCachingAnnotations(method.modifiers()).forEach(ann -> {
            String name = ann.symbolType().name();
            this.reportIssue((Tree)ann, String.format(ISSUE_MESSAGE, name));
        }));
    }

    private static Stream<AnnotationTree> selectCachingAnnotations(ModifiersTree m) {
        return m.annotations().stream().filter(ann -> {
            String fullyQualifiedName = ann.annotationType().symbolType().fullyQualifiedName();
            return CACHING_ANNOTATIONS.contains(fullyQualifiedName);
        });
    }
}

