/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6833")
public class ControllerWithRestControllerReplacementCheck
extends IssuableSubscriptionVisitor {
    private static final String RESPONSE_BODY = "org.springframework.web.bind.annotation.ResponseBody";
    private static final List<String> MAPPING_ANNOTATIONS = List.of("org.springframework.web.bind.annotation.RequestMapping", "org.springframework.web.bind.annotation.GetMapping", "org.springframework.web.bind.annotation.PostMapping", "org.springframework.web.bind.annotation.PutMapping", "org.springframework.web.bind.annotation.PatchMapping", "org.springframework.web.bind.annotation.DeleteMapping");

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        Optional<AnnotationTree> annotation = classTree.modifiers().annotations().stream().filter(a -> "org.springframework.stereotype.Controller".equals(a.annotationType().symbolType().fullyQualifiedName())).findFirst();
        if (annotation.isEmpty()) {
            return;
        }
        ArrayList<AnnotationTree> responseBodyOnMethods = new ArrayList<AnnotationTree>();
        for (Tree member : classTree.members()) {
            if (!(member instanceof MethodTree)) continue;
            MethodTree method = (MethodTree)member;
            Optional<AnnotationTree> response = ControllerWithRestControllerReplacementCheck.firstAnnotation(method, List.of(RESPONSE_BODY));
            if (response.isPresent()) {
                responseBodyOnMethods.add(response.get());
                continue;
            }
            if (!ControllerWithRestControllerReplacementCheck.firstAnnotation(method, MAPPING_ANNOTATIONS).isPresent()) continue;
            return;
        }
        ArrayList secondaryLocations = new ArrayList();
        ArrayList edits = new ArrayList();
        responseBodyOnMethods.forEach(ann -> {
            secondaryLocations.add(new JavaFileScannerContext.Location("Remove this \"@ResponseBody\" annotation.", (Tree)ann));
            edits.add(JavaTextEdit.removeTree((Tree)ann));
        });
        classTree.modifiers().annotations().stream().filter(ControllerWithRestControllerReplacementCheck::isResponseBody).forEach(annotationTree -> secondaryLocations.add(new JavaFileScannerContext.Location("Remove this \"@ResponseBody\" annotation.", (Tree)annotationTree)));
        if (secondaryLocations.isEmpty()) {
            return;
        }
        QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)annotation.get()).withMessage("Replace the \"@Controller\" annotation by \"@RestController\" and remove all \"@ResponseBody\" annotations.").withSecondaries(secondaryLocations).withQuickFixes(() -> List.of(JavaQuickFix.newQuickFix((String)"Remove \"@ResponseBody\" annotations.").addTextEdits(edits).build(), JavaQuickFix.newQuickFix((String)"Replace \"@Controller\" by \"@RestController\".").addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)((Tree)annotation.get()), (String)"@RestController")}).build())).report();
    }

    private static boolean isResponseBody(AnnotationTree a) {
        return RESPONSE_BODY.equals(a.symbolType().fullyQualifiedName());
    }

    private static Optional<AnnotationTree> firstAnnotation(MethodTree method, List<String> annFullyQualifiedNames) {
        for (AnnotationTree annotation : method.modifiers().annotations()) {
            String fqn = annotation.symbolType().fullyQualifiedName();
            if (!annFullyQualifiedNames.contains(fqn)) continue;
            return Optional.of(annotation);
        }
        return Optional.empty();
    }
}

