/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S7177")
public class DirtyContextShouldUseCorrectControlModeCheck
extends IssuableSubscriptionVisitor {
    private static final String DIRTY_CONTEXT = "org.springframework.test.annotation.DirtiesContext";
    private static final String REPLACE_CLASS_MODE = "Replace classMode with methodMode.";
    private static final String REPLACE_METHOD_MODE = "Replace methodMode with classMode.";
    private static final String CLASS_MODE = "classMode";
    private static final String METHOD_MODE = "methodMode";

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD, Tree.Kind.CLASS, Tree.Kind.RECORD);
    }

    public void visitNode(Tree tree) {
        if (tree instanceof MethodTree) {
            MethodTree method = (MethodTree)tree;
            this.forEachDirtyContextArguments(method.modifiers(), CLASS_MODE, REPLACE_CLASS_MODE);
        } else {
            ClassTree clazz = (ClassTree)tree;
            this.forEachDirtyContextArguments(clazz.modifiers(), METHOD_MODE, REPLACE_METHOD_MODE);
        }
    }

    private void forEachDirtyContextArguments(ModifiersTree modifiers, String targetedArgument, String issueMessage) {
        for (AnnotationTree ann : modifiers.annotations()) {
            if (!ann.symbolType().is(DIRTY_CONTEXT)) continue;
            for (ExpressionTree expr : ann.arguments()) {
                AssignmentExpressionTree assign = (AssignmentExpressionTree)expr;
                IdentifierTree ident = (IdentifierTree)assign.variable();
                if (!ident.name().equals(targetedArgument)) continue;
                this.reportIssue((Tree)ident, issueMessage);
            }
        }
    }
}

