/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S7185")
public class EventListenerMethodOneArgCheck
extends IssuableSubscriptionVisitor {
    static final String EVENT_LISTENER_FQN = "org.springframework.context.event.EventListener";

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (EventListenerMethodOneArgCheck.annotatedEventListener(methodTree) && methodTree.parameters().size() > 1) {
            this.reportIssue((Tree)methodTree.simpleName(), "Methods annotated \"@EventListener\" can have at most one argument");
        }
    }

    private static boolean annotatedEventListener(MethodTree methodTree) {
        return methodTree.modifiers().annotations().stream().anyMatch(annotation -> annotation.annotationType().symbolType().is(EVENT_LISTENER_FQN));
    }
}

