/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6856")
public class MissingPathVariableAnnotationCheck
extends IssuableSubscriptionVisitor {
    private static final String PATH_VARIABLE_ANNOTATION = "org.springframework.web.bind.annotation.PathVariable";
    private static final String MAP = "java.util.Map";
    private static final String MODEL_ATTRIBUTE_ANNOTATION = "org.springframework.web.bind.annotation.ModelAttribute";
    private static final String REQUEST_MAPPING_ANNOTATION = "org.springframework.web.bind.annotation.RequestMapping";
    private static final String PROPERTY_PLACEHOLDER_PATTERN = "\\$\\{[^{}]*\\}";
    private static final Set<String> MAPPING_ANNOTATIONS = Set.of("org.springframework.web.bind.annotation.RequestMapping", "org.springframework.web.bind.annotation.GetMapping", "org.springframework.web.bind.annotation.PostMapping", "org.springframework.web.bind.annotation.PutMapping", "org.springframework.web.bind.annotation.DeleteMapping", "org.springframework.web.bind.annotation.PatchMapping");

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree clazzTree = (ClassTree)tree;
        List<MethodTree> methods = clazzTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(MethodTree.class::cast).toList();
        List requestMappingArguments = clazzTree.symbol().metadata().valuesForAnnotation(REQUEST_MAPPING_ANNOTATION);
        HashSet<String> requestMappingTemplateVariables = new HashSet();
        if (requestMappingArguments != null) {
            try {
                requestMappingTemplateVariables = MissingPathVariableAnnotationCheck.templateVariablesFromMapping(requestMappingArguments);
            }
            catch (DoNotReport ignored) {
                return;
            }
        }
        Set<String> modelAttributeMethodParameter = MissingPathVariableAnnotationCheck.extractModelAttributeMethodParameter(methods);
        modelAttributeMethodParameter.addAll(MissingPathVariableAnnotationCheck.addInheritedModelAttributeMethodParameter(modelAttributeMethodParameter, clazzTree));
        this.checkParametersAndPathTemplate(methods, modelAttributeMethodParameter, requestMappingTemplateVariables);
    }

    private static Set<String> extractModelAttributeMethodParameter(List<MethodTree> methods) {
        HashSet<String> modelAttributeMethodParameter = new HashSet<String>();
        for (MethodTree method : methods) {
            if (!method.symbol().metadata().isAnnotatedWith(MODEL_ATTRIBUTE_ANNOTATION)) continue;
            for (VariableTree parameter : method.parameters()) {
                SymbolMetadata metadata = parameter.symbol().metadata();
                List arguments = metadata.valuesForAnnotation(PATH_VARIABLE_ANNOTATION);
                if (arguments == null) continue;
                modelAttributeMethodParameter.add(MissingPathVariableAnnotationCheck.extractPathMethodParameters((VariableTree)parameter, (List<SymbolMetadata.AnnotationValue>)arguments).value);
            }
        }
        return modelAttributeMethodParameter;
    }

    private static Set<String> addInheritedModelAttributeMethodParameter(Set<String> modelAttributeMethodParameters, ClassTree clazz) {
        if (clazz.superClass() == null) {
            return modelAttributeMethodParameters;
        }
        Type superClass = clazz.superClass().symbolType();
        ClassTree declaration = superClass.symbol().declaration();
        if (declaration != null) {
            List<MethodTree> methods = declaration.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(MethodTree.class::cast).toList();
            modelAttributeMethodParameters.addAll(MissingPathVariableAnnotationCheck.extractModelAttributeMethodParameter(methods));
            modelAttributeMethodParameters.addAll(MissingPathVariableAnnotationCheck.addInheritedModelAttributeMethodParameter(modelAttributeMethodParameters, declaration));
        }
        return modelAttributeMethodParameters;
    }

    private void checkParametersAndPathTemplate(List<MethodTree> methods, Set<String> modelAttributeMethodParameter, Set<String> requestMappingTemplateVariables) {
        for (MethodTree method : methods) {
            if (method.symbol().metadata().isAnnotatedWith(MODEL_ATTRIBUTE_ANNOTATION)) continue;
            try {
                this.checkParametersAndPathTemplate(method, modelAttributeMethodParameter, requestMappingTemplateVariables);
            }
            catch (DoNotReport doNotReport) {}
        }
    }

    private void checkParametersAndPathTemplate(MethodTree method, Set<String> modelAttributeMethodParameters, Set<String> requestMappingTemplateVars) {
        ArrayList<ParameterInfo> methodParameters = new ArrayList<ParameterInfo>();
        for (Object parameter : method.parameters()) {
            SymbolMetadata metadata = parameter.symbol().metadata();
            if (metadata.annotations().stream().anyMatch(ann -> ann.symbol().isUnknown())) {
                throw new DoNotReport();
            }
            List arguments = metadata.valuesForAnnotation(PATH_VARIABLE_ANNOTATION);
            if (arguments == null) continue;
            methodParameters.add(MissingPathVariableAnnotationCheck.extractPathMethodParameters((VariableTree)parameter, arguments));
        }
        ArrayList<UriInfo<Set<String>>> templateVariables = new ArrayList<UriInfo<Set<String>>>();
        for (AnnotationTree ann2 : method.modifiers().annotations()) {
            if (ann2.symbolType().isUnknown()) {
                throw new DoNotReport();
            }
            String fullyQualifiedName = ann2.annotationType().symbolType().fullyQualifiedName();
            List values = method.symbol().metadata().valuesForAnnotation(fullyQualifiedName);
            if (values == null || !MAPPING_ANNOTATIONS.contains(fullyQualifiedName)) continue;
            templateVariables.add(new UriInfo<Set<String>>(ann2, MissingPathVariableAnnotationCheck.templateVariablesFromMapping(values)));
        }
        Set allTemplateVariables = templateVariables.stream().flatMap(uri -> ((Set)uri.value()).stream()).collect(Collectors.toSet());
        allTemplateVariables.addAll(requestMappingTemplateVars);
        methodParameters.stream().filter(v -> !allTemplateVariables.contains(v.value())).filter(v -> !v.parameter().symbol().type().is(MAP)).forEach(v -> this.reportIssue((Tree)v.parameter(), String.format("Bind method parameter \"%s\" to a template variable.", v.value())));
        if (MissingPathVariableAnnotationCheck.containsTypeMapAsParameter(method)) {
            return;
        }
        Set allPathVariables = methodParameters.stream().map(ParameterInfo::value).collect(Collectors.toSet());
        allPathVariables.addAll(modelAttributeMethodParameters);
        templateVariables.stream().filter(uri -> !allPathVariables.containsAll((Collection)uri.value())).forEach(uri -> {
            HashSet unbind = new HashSet((Collection)uri.value());
            unbind.removeAll(allPathVariables);
            this.reportIssue((Tree)uri.request(), "Bind template variable \"" + String.join((CharSequence)"\", \"", unbind) + "\" to a method parameter.");
        });
    }

    private static boolean containsTypeMapAsParameter(MethodTree method) {
        return method.parameters().stream().filter(parameter -> parameter.symbol().metadata().isAnnotatedWith(PATH_VARIABLE_ANNOTATION)).anyMatch(parameter -> {
            Type type = parameter.type().symbolType();
            return type.isSubtypeOf(MAP);
        });
    }

    private static Set<String> templateVariablesFromMapping(List<SymbolMetadata.AnnotationValue> values) {
        Map<String, Object> nameToValue = values.stream().collect(Collectors.toMap(SymbolMetadata.AnnotationValue::name, SymbolMetadata.AnnotationValue::value));
        List<String> path = MissingPathVariableAnnotationCheck.arrayOrString(nameToValue.get("path"));
        List<String> value = MissingPathVariableAnnotationCheck.arrayOrString(nameToValue.get("value"));
        if (path != null || value != null) {
            List<String> paths = path != null ? path : value;
            return paths.stream().map(MissingPathVariableAnnotationCheck::removePropertyPlaceholder).map(PathPatternParser::parsePathVariables).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        return Set.of();
    }

    private static ParameterInfo extractPathMethodParameters(VariableTree parameter, List<SymbolMetadata.AnnotationValue> arguments) {
        Map<String, Object> argNameToValue = arguments.stream().collect(Collectors.toMap(SymbolMetadata.AnnotationValue::name, SymbolMetadata.AnnotationValue::value));
        String value = (String)argNameToValue.get("value");
        String name = (String)argNameToValue.get("name");
        if (value != null) {
            return new ParameterInfo(parameter, value);
        }
        if (name != null) {
            return new ParameterInfo(parameter, name);
        }
        return new ParameterInfo(parameter, parameter.simpleName().name());
    }

    @Nullable
    private static List<String> arrayOrString(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        Object[] array = (Object[])value;
        return Stream.of(array).map(el -> (String)el).toList();
    }

    private static String removePropertyPlaceholder(String path) {
        return path.replaceAll(PROPERTY_PLACEHOLDER_PATTERN, "");
    }

    static class DoNotReport
    extends RuntimeException {
        DoNotReport() {
        }
    }

    private record ParameterInfo(VariableTree parameter, String value) {
    }

    private record UriInfo<A>(AnnotationTree request, A value) {
    }

    static class PathPatternParser {
        private static final String REST_PATH_WILDCARD = "{**}";
        private static final String PREFIX_REST_PATH_VARIABLE = "{*";
        private static final String PREFIX_REGEX_PATH_VARIABLE = "{";
        private static int pos;
        private static String path;
        private static Set<String> vars;

        private PathPatternParser() {
        }

        public static Set<String> parsePathVariables(String urlPath) {
            pos = 0;
            path = urlPath;
            vars = new HashSet<String>();
            while (pos < path.length()) {
                if (!PathPatternParser.matchPrefix(PREFIX_REGEX_PATH_VARIABLE)) {
                    PathPatternParser.consumeCurrentChar();
                    continue;
                }
                if (PathPatternParser.ifMatchConsumeRestPathWildcard() || PathPatternParser.ifMatchConsumeRestPathVariable()) continue;
                PathPatternParser.consumeRegexPathVariable();
            }
            return vars;
        }

        private static boolean ifMatchConsumeRestPathWildcard() {
            if (PathPatternParser.matchPrefix(REST_PATH_WILDCARD)) {
                PathPatternParser.consumePrefix(REST_PATH_WILDCARD);
                return true;
            }
            return false;
        }

        private static boolean ifMatchConsumeRestPathVariable() {
            if (!PathPatternParser.matchPrefix(PREFIX_REST_PATH_VARIABLE)) {
                return false;
            }
            PathPatternParser.consumePrefix(PREFIX_REST_PATH_VARIABLE);
            int startTemplateVar = pos;
            while (pos < path.length()) {
                char current = PathPatternParser.consumeCurrentChar();
                if (current != '}') continue;
                vars.add(PathPatternParser.substringToCurrentChar(startTemplateVar));
                return true;
            }
            throw new DoNotReport();
        }

        private static void consumeRegexPathVariable() {
            if (!PathPatternParser.matchPrefix(PREFIX_REGEX_PATH_VARIABLE)) {
                throw new DoNotReport();
            }
            if (PathPatternParser.matchPrefix("{}")) {
                throw new DoNotReport();
            }
            PathPatternParser.consumePrefix(PREFIX_REGEX_PATH_VARIABLE);
            int startTemplateVar = pos;
            while (pos < path.length()) {
                char current = PathPatternParser.consumeCurrentChar();
                if (current == '}') {
                    vars.add(PathPatternParser.substringToCurrentChar(startTemplateVar));
                    return;
                }
                if (current != ':') continue;
                vars.add(PathPatternParser.substringToCurrentChar(startTemplateVar));
                PathPatternParser.consumeRegex();
                return;
            }
            throw new DoNotReport();
        }

        private static void consumeRegex() {
            while (pos < path.length()) {
                char current = PathPatternParser.consumeCurrentChar();
                if (current == '}') {
                    return;
                }
                if (current != '{') continue;
                PathPatternParser.consumeRegex();
            }
            throw new DoNotReport();
        }

        private static boolean matchPrefix(String prefix) {
            int endPosPrefix = pos + prefix.length();
            if (endPosPrefix <= path.length()) {
                return prefix.equals(path.substring(pos, endPosPrefix));
            }
            return false;
        }

        private static char consumeCurrentChar() {
            return path.charAt(++pos - 1);
        }

        private static void consumePrefix(String prefix) {
            pos += prefix.length();
        }

        private static String substringToCurrentChar(int start) {
            return path.substring(start, pos - 1);
        }
    }
}

