/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.location.Position;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.standard.SpelExpressionParser;

@Rule(key="S6857")
public class SpelExpressionCheck
extends IssuableSubscriptionVisitor {
    private static final String SPRING_PREFIX = "org.springframework";
    private static final Pattern PROPERTY_PLACEHOLDER_PATTERN = Pattern.compile("[a-zA-Z0-9/_-]++(\\[\\d++])*+(\\.[a-zA-Z0-9/_-]++(\\[\\d++])*+)*+");

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.CLASS, Tree.Kind.INTERFACE);
    }

    public void visitNode(Tree tree) {
        SpelExpressionCheck.getClassAndMemberAnnotations((ClassTree)tree).filter(SpelExpressionCheck::isSpringAnnotation).forEach(this::checkSpringAnnotationArguments);
    }

    private static Stream<AnnotationTree> getClassAndMemberAnnotations(ClassTree cls) {
        return Stream.concat(Stream.of(cls.modifiers().annotations()), cls.members().stream().map(SpelExpressionCheck::getMemberAnnotations)).flatMap(Collection::stream);
    }

    private static List<AnnotationTree> getMemberAnnotations(Tree member) {
        if (member.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            return ((MethodTree)member).modifiers().annotations();
        }
        if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            return ((VariableTree)member).modifiers().annotations();
        }
        return Collections.emptyList();
    }

    private static boolean isSpringAnnotation(AnnotationTree annotation) {
        return annotation.symbolType().fullyQualifiedName().startsWith(SPRING_PREFIX);
    }

    private void checkSpringAnnotationArguments(AnnotationTree annotation) {
        annotation.arguments().stream().map(SpelExpressionCheck::extractArgumentValue).filter(Objects::nonNull).forEach(this::checkSpringExpressionsInString);
    }

    @CheckForNull
    private static Map.Entry<Tree, String> extractArgumentValue(ExpressionTree expression) {
        String stringValue = (String)ExpressionsHelper.getConstantValueAsString((ExpressionTree)(expression = SpelExpressionCheck.getExpressionOrAssignmentRhs(expression))).value();
        if (stringValue == null) {
            return null;
        }
        return Map.entry(expression, stringValue);
    }

    private static ExpressionTree getExpressionOrAssignmentRhs(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) ? ((AssignmentExpressionTree)expression).expression() : expression;
    }

    private void checkSpringExpressionsInString(Map.Entry<Tree, String> entry) {
        Tree expression = entry.getKey();
        try {
            String argValue = entry.getValue();
            if (expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
                SpelExpressionCheck.checkStringContents(new ParseCtx(argValue, 1));
            } else {
                SpelExpressionCheck.checkStringContents(new ParseCtx(argValue, 0));
            }
        }
        catch (SyntaxError e) {
            this.reportIssue(expression, e);
        }
    }

    private void reportIssue(Tree expression, SyntaxError error) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            Position tokenStart = Position.startOf((Tree)expression);
            AnalyzerMessage.TextSpan textSpan = new AnalyzerMessage.TextSpan(tokenStart.line(), tokenStart.columnOffset() + error.range.start, tokenStart.line(), tokenStart.columnOffset() + error.range.end);
            AnalyzerMessage analyzerMessage = new AnalyzerMessage((JavaCheck)this, (InputComponent)this.context.getInputFile(), textSpan, error.getMessage(), 0);
            ((DefaultJavaFileScannerContext)this.context).reportIssue(analyzerMessage);
        } else {
            this.reportIssue(expression, error.getMessage());
        }
    }

    private static void checkStringContents(ParseCtx ctx) throws SyntaxError {
        String expressionSource = ctx.expressionSource();
        int idx = 0;
        while (idx < expressionSource.length()) {
            if (PropertyPlaceholder.matchPrefix(expressionSource, idx)) {
                Placeholder placeholder = PropertyPlaceholder.parse(ctx, idx);
                idx = placeholder.range.end;
                continue;
            }
            if (SpEL.matchPrefix(expressionSource, idx)) {
                SpELExpr expr = SpEL.parse(ctx, idx);
                idx = expr.range.end;
                continue;
            }
            ++idx;
        }
    }

    private record ParseCtx(String expressionSource, int offset) {
    }

    private static class SyntaxError
    extends RuntimeException {
        public final Range range;

        SyntaxError(String message, Range range) {
            super(message);
            this.range = range;
        }
    }

    private record Range(int start, int end) implements Serializable
    {
        public Range {
            if (start >= end) {
                throw new IllegalArgumentException("Range must be non-empty; start value must be less than end value.");
            }
        }

        public Range addOffset(int offset) {
            return new Range(this.start + offset, this.end + offset);
        }
    }

    private static class PropertyPlaceholder {
        private static final char PREFIX = '$';

        private PropertyPlaceholder() {
        }

        static boolean matchPrefix(String expressionSource, int idx) {
            return idx + 1 < expressionSource.length() && expressionSource.charAt(idx) == '$' && expressionSource.charAt(idx + 1) == '{';
        }

        static Placeholder parse(ParseCtx ctx, int startIdx) {
            int startExpr;
            String expressionSource = ctx.expressionSource();
            if (!PropertyPlaceholder.matchPrefix(expressionSource, startIdx)) {
                throw new IllegalArgumentException();
            }
            Record state = new Expr();
            for (int idx = startExpr = startIdx + 2; idx < expressionSource.length(); ++idx) {
                char current = expressionSource.charAt(idx);
                if (state instanceof Expr && (current == '}' || current == ':')) {
                    String expr = expressionSource.substring(startExpr, idx).trim();
                    if (current == '}') {
                        return new Placeholder(ctx.offset(), new Range(startIdx, idx + 1), expr, null);
                    }
                    state = new DefaultValue(0, expr, idx + 1);
                    continue;
                }
                if (state instanceof DefaultValue) {
                    DefaultValue d = (DefaultValue)state;
                    if (current == '}' && d.nestingLevel == 0) {
                        return new Placeholder(ctx.offset(), new Range(startIdx, idx + 1), d.expr, expressionSource.substring(d.startDefault, idx).trim());
                    }
                }
                if (!(state instanceof DefaultValue)) continue;
                DefaultValue d = (DefaultValue)state;
                if (SpEL.matchPrefix(expressionSource, idx)) {
                    SpEL.parse(ctx, idx);
                    continue;
                }
                if (current == '{') {
                    state = d.increaseNestingLevel();
                    continue;
                }
                if (current != '}') continue;
                state = d.decreaseNestingLevel();
            }
            Range range = new Range(startIdx, expressionSource.length());
            throw new SyntaxError("Add missing '}' for this property placeholder or SpEL expression.", range.addOffset(ctx.offset()));
        }

        record Expr() implements ParseStates
        {
        }

        record DefaultValue(int nestingLevel, String expr, int startDefault) implements ParseStates
        {
            DefaultValue increaseNestingLevel() {
                return new DefaultValue(this.nestingLevel + 1, this.expr, this.startDefault);
            }

            DefaultValue decreaseNestingLevel() {
                return new DefaultValue(this.nestingLevel - 1, this.expr, this.startDefault);
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        static interface ParseStates {
        }
    }

    record Placeholder(int offset, Range range, String expr, @Nullable String defaultValue) {
        public Placeholder {
            if (!PROPERTY_PLACEHOLDER_PATTERN.asMatchPredicate().test(expr)) {
                throw new SyntaxError("Correct this malformed property placeholder.", range.addOffset(offset));
            }
        }

        public String evaluate(String expressionSource) {
            int before;
            int n = before = this.range.start > 0 ? (int)expressionSource.charAt(this.range.start - 1) : 32;
            if (before == 64) {
                return "bean";
            }
            return "#var";
        }
    }

    private static class SpEL {
        private static final char PREFIX = '#';

        private SpEL() {
        }

        static boolean matchPrefix(String expressionSource, int startIdx) {
            return startIdx + 1 < expressionSource.length() && expressionSource.charAt(startIdx) == '#' && expressionSource.charAt(startIdx + 1) == '{';
        }

        static SpELExpr parse(ParseCtx ctx, int startIdx) {
            String expressionSource = ctx.expressionSource();
            if (!SpEL.matchPrefix(expressionSource, startIdx)) {
                throw new IllegalArgumentException();
            }
            int startExpr = startIdx + 2;
            StringBuilder evaluated = new StringBuilder();
            int nestingLevel = 0;
            int idx = startExpr;
            while (idx < expressionSource.length()) {
                char current = expressionSource.charAt(idx);
                if (PropertyPlaceholder.matchPrefix(expressionSource, idx)) {
                    Placeholder placeholder = PropertyPlaceholder.parse(ctx, idx);
                    evaluated.append(placeholder.evaluate(expressionSource));
                    idx = placeholder.range.end;
                    continue;
                }
                if (current == '}' && nestingLevel == 0) {
                    return new SpELExpr(evaluated.toString(), new Range(startIdx, idx + 1), ctx.offset());
                }
                evaluated.append(expressionSource.charAt(idx));
                if (current == '{') {
                    ++nestingLevel;
                } else if (current == '}') {
                    --nestingLevel;
                }
                ++idx;
            }
            Range range = new Range(startIdx, expressionSource.length());
            throw new SyntaxError("Add missing '}' for this property placeholder or SpEL expression.", range.addOffset(ctx.offset()));
        }
    }

    record SpELExpr(String expr, Range range, int offset) {
        public SpELExpr {
            try {
                new SpelExpressionParser().parseExpression(expr);
            }
            catch (IllegalArgumentException | IllegalStateException | ParseException e) {
                throw new SyntaxError("Correct this malformed SpEL expression.", range.addOffset(offset));
            }
        }
    }
}

