/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S7179")
public class SpringCacheableWithCachePutCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE_FORMAT = "Remove the \"@CachePut\" annotation or the \"@Cacheable\" annotation located on the same %s.";
    private static final String CLASS_MESSAGE = String.format("Remove the \"@CachePut\" annotation or the \"@Cacheable\" annotation located on the same %s.", "class");
    private static final String METHOD_MESSAGE = String.format("Remove the \"@CachePut\" annotation or the \"@Cacheable\" annotation located on the same %s.", "method");
    private static final String WRONG_CACHE_PUT_METHOD_MESSAGE = "Methods of a @Cacheable class should not be annotated with \"@CachePut\".";
    private static final String WRONG_CACHEABLE_METHOD_MESSAGE = "Methods of a @CachePut class should not be annotated with \"@Cacheable\".";
    private static final String CACHE_PUT_FQN = "org.springframework.cache.annotation.CachePut";
    private static final String CACHEABLE_FQN = "org.springframework.cache.annotation.Cacheable";

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD, Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (tree instanceof MethodTreeImpl) {
            MethodTreeImpl methodTree = (MethodTreeImpl)tree;
            Symbol.MethodSymbol methodSymbol = methodTree.symbol();
            if (SpringCacheableWithCachePutCheck.isSymbolAnnotatedWithCacheableAndCachePut((Symbol)methodSymbol)) {
                this.reportIssue((Tree)methodTree.simpleName(), METHOD_MESSAGE, SpringCacheableWithCachePutCheck.getSecondaryLocations((Symbol)methodSymbol), null);
            } else if (SpringCacheableWithCachePutCheck.isAnnotatedWithCachePut((Symbol)methodSymbol) && SpringCacheableWithCachePutCheck.isAnnotatedWithCacheable((Symbol)methodSymbol.enclosingClass())) {
                List<JavaFileScannerContext.Location> secondaryLocations = SpringCacheableWithCachePutCheck.getSecondaryLocations((Symbol)methodSymbol, (Symbol)methodSymbol.enclosingClass());
                this.reportIssue((Tree)methodTree.simpleName(), WRONG_CACHE_PUT_METHOD_MESSAGE, secondaryLocations, null);
            } else if (SpringCacheableWithCachePutCheck.isAnnotatedWithCacheable((Symbol)methodSymbol) && SpringCacheableWithCachePutCheck.isAnnotatedWithCachePut((Symbol)methodSymbol.enclosingClass())) {
                List<JavaFileScannerContext.Location> secondaryLocations = SpringCacheableWithCachePutCheck.getSecondaryLocations((Symbol)methodSymbol, (Symbol)methodSymbol.enclosingClass());
                this.reportIssue((Tree)methodTree.simpleName(), WRONG_CACHEABLE_METHOD_MESSAGE, secondaryLocations, null);
            }
        } else {
            ClassTreeImpl classTree = (ClassTreeImpl)tree;
            Symbol.TypeSymbol classSymbol = classTree.symbol();
            if (SpringCacheableWithCachePutCheck.isSymbolAnnotatedWithCacheableAndCachePut((Symbol)classSymbol)) {
                this.reportIssue((Tree)classTree.simpleName(), CLASS_MESSAGE, SpringCacheableWithCachePutCheck.getSecondaryLocations((Symbol)classSymbol), null);
            }
        }
    }

    private static boolean isAnnotatedWithCachePut(Symbol symbol) {
        return symbol.metadata().isAnnotatedWith(CACHE_PUT_FQN);
    }

    private static boolean isAnnotatedWithCacheable(Symbol symbol) {
        return symbol.metadata().isAnnotatedWith(CACHEABLE_FQN);
    }

    private static boolean isSymbolAnnotatedWithCacheableAndCachePut(Symbol symbol) {
        return SpringCacheableWithCachePutCheck.isAnnotatedWithCachePut(symbol) && SpringCacheableWithCachePutCheck.isAnnotatedWithCacheable(symbol);
    }

    private static List<JavaFileScannerContext.Location> getSecondaryLocations(Symbol symbol) {
        SymbolMetadata symbolMetadata = symbol.metadata();
        return symbolMetadata.annotations().stream().filter(annotation -> annotation.symbol().type().is(CACHEABLE_FQN) || annotation.symbol().type().is(CACHE_PUT_FQN)).map(annotation -> new JavaFileScannerContext.Location(annotation.symbol().name(), (Tree)symbolMetadata.findAnnotationTree(annotation))).collect(Collectors.toList());
    }

    private static List<JavaFileScannerContext.Location> getSecondaryLocations(Symbol first, Symbol second) {
        List<JavaFileScannerContext.Location> locations = SpringCacheableWithCachePutCheck.getSecondaryLocations(first);
        locations.addAll(SpringCacheableWithCachePutCheck.getSecondaryLocations(second));
        return locations;
    }
}

