/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S7178")
public class StaticFieldInjectionNotSupportedCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> INJECTIONS_ANNOTATIONS = Set.of("javax.inject.Inject", "org.springframework.beans.factory.annotation.Autowired", "jakarta.inject.Inject", "org.springframework.beans.factory.annotation.Value");
    private static final String STATIC_FIELD_MESSAGE = "Remove this injection annotation targeting the static field.";
    private static final String STATIC_METHOD_MESSAGE = "Remove this injection annotation targeting the static method.";
    private static final String STATIC_PARAMETER_MESSAGE = "Remove this injection annotation targeting the parameter.";
    private static final String SPRING_PREFIX = "org.springframework";
    private boolean analyzingSpringProject = false;

    public void setContext(JavaFileScannerContext context) {
        super.setContext(context);
        this.analyzingSpringProject = false;
    }

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD, Tree.Kind.CLASS, Tree.Kind.COMPILATION_UNIT);
    }

    public void visitNode(Tree tree) {
        MethodTree method;
        if (tree instanceof CompilationUnitTree) {
            CompilationUnitTree compilationUnit = (CompilationUnitTree)tree;
            this.analyzingSpringProject = compilationUnit.imports().stream().filter(ImportTree.class::isInstance).map(ImportTree.class::cast).anyMatch(i -> ExpressionsHelper.concatenate((ExpressionTree)((ExpressionTree)i.qualifiedIdentifier())).startsWith(SPRING_PREFIX));
        }
        if (!this.analyzingSpringProject) {
            return;
        }
        if (tree instanceof MethodTree && (method = (MethodTree)tree).symbol().isStatic()) {
            StaticFieldInjectionNotSupportedCheck.selectInjectionAnnotations(method.modifiers()).forEach(ann -> this.reportIssue((Tree)ann, STATIC_METHOD_MESSAGE));
            method.parameters().stream().map(p -> StaticFieldInjectionNotSupportedCheck.selectInjectionAnnotations(p.modifiers())).forEach(anns -> anns.forEach(ann -> this.reportIssue((Tree)ann, STATIC_PARAMETER_MESSAGE)));
        } else if (tree instanceof ClassTree) {
            ClassTree clazz = (ClassTree)tree;
            Stream<VariableTree> staticFields = clazz.members().stream().filter(child -> {
                VariableTree v;
                return child instanceof VariableTree && (v = (VariableTree)child).symbol().isStatic();
            }).map(VariableTree.class::cast);
            staticFields.map(v -> StaticFieldInjectionNotSupportedCheck.selectInjectionAnnotations(v.modifiers())).forEach(anns -> anns.forEach(ann -> this.reportIssue((Tree)ann, STATIC_FIELD_MESSAGE)));
        }
    }

    private static List<AnnotationTree> selectInjectionAnnotations(ModifiersTree m) {
        return m.annotations().stream().filter(ann -> INJECTIONS_ANNOTATIONS.contains(ann.annotationType().symbolType().fullyQualifiedName())).toList();
    }
}

