/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.DependencyVersionAware;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.Version;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2230")
public class TransactionalMethodVisibilityCheck
extends IssuableSubscriptionVisitor
implements DependencyVersionAware {
    private static final List<String> PROXY_ANNOTATIONS = List.of("org.springframework.transaction.annotation.Transactional", "org.springframework.scheduling.annotation.Async");
    private static final Map<String, String> ANNOTATION_SHORT_NAMES = Map.of("org.springframework.transaction.annotation.Transactional", "@Transactional", "org.springframework.scheduling.annotation.Async", "@Async");
    private boolean isSpring6OrLater = false;

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        boolean handledBySpring;
        MethodTree method = (MethodTree)tree;
        boolean bl = this.isSpring6OrLater ? !method.symbol().isPrivate() : (handledBySpring = method.symbol().isPublic());
        if (!handledBySpring) {
            PROXY_ANNOTATIONS.stream().filter(annSymbol -> TransactionalMethodVisibilityCheck.hasAnnotation(method, annSymbol)).forEach(annSymbol -> this.reportIssue((Tree)method.simpleName(), "Make this method " + this.requiredVisibilityMessage() + " or remove the \"" + ANNOTATION_SHORT_NAMES.get(annSymbol) + "\" annotation."));
        }
    }

    private String requiredVisibilityMessage() {
        return this.isSpring6OrLater ? "non-\"private\"" : "\"public\"";
    }

    private static boolean hasAnnotation(MethodTree method, String annotationSymbol) {
        for (AnnotationTree annotation : method.modifiers().annotations()) {
            if (!annotation.symbolType().is(annotationSymbol)) continue;
            return true;
        }
        return false;
    }

    public boolean isCompatibleWithDependencies(Function<String, Optional<Version>> dependencyFinder) {
        Optional<Version> springContextVersion = dependencyFinder.apply("spring-context");
        Optional<Version> springTxVersion = dependencyFinder.apply("spring-tx");
        if (springTxVersion.isEmpty() && springContextVersion.isEmpty()) {
            return false;
        }
        this.isSpring6OrLater = springContextVersion.or(() -> springTxVersion).map(v -> v.isGreaterThanOrEqualTo("6.0")).orElse(false);
        return true;
    }
}

