/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.AbstractAssertionVisitor;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.model.expression.MethodInvocationTreeImpl;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2699")
public class AssertionsInTestsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Logger LOG = LoggerFactory.getLogger(AssertionsInTestsCheck.class);
    @RuleProperty(key="customAssertionMethods", description="Comma-separated list of fully qualified method symbols that should be considered as assertion methods. The wildcard character can be used at the end of the method name.", defaultValue="")
    public String customAssertionMethods = "";
    private MethodMatchers customAssertionMethodsMatcher = null;
    private static final MethodMatchers SPRING_BOOT_APP_CTX_RUNNER_RUN_MATCHER = MethodMatchers.create().ofTypes(new String[]{"org.springframework.boot.test.context.runner.ApplicationContextRunner"}).names(new String[]{"run"}).addParametersMatcher(new String[]{"org.springframework.boot.test.context.runner.ContextConsumer"}).build();
    private static final MethodInvocationMatcherVisitor SPRING_BOOT_APP_CTX_RUNNER_VISITOR = new MethodInvocationMatcherVisitor(SPRING_BOOT_APP_CTX_RUNNER_RUN_MATCHER);
    private final Map<Symbol, Boolean> assertionInMethod = new HashMap<Symbol, Boolean>();
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        if (context.getSemanticModel() == null) {
            return;
        }
        this.context = context;
        this.assertionInMethod.clear();
        this.scan((Tree)context.getTree());
        this.assertionInMethod.clear();
    }

    public void visitMethod(MethodTree methodTree) {
        if (ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.ABSTRACT)) {
            return;
        }
        if (UnitTestUtils.isUnitTest(methodTree)) {
            if (this.isSpringBootAssertableContext(methodTree)) {
                return;
            }
            if (!(AssertionsInTestsCheck.isSpringBootSanityTest(methodTree) || AssertionsInTestsCheck.expectAssertion(methodTree) || this.isLocalMethodWithAssertion((Symbol)methodTree.symbol()))) {
                this.context.reportIssue((JavaCheck)this, (Tree)methodTree.simpleName(), "Add at least one assertion to this test case.");
            }
        }
    }

    private boolean isSpringBootAssertableContext(MethodTree methodTree) {
        MethodInvocationTreeImpl runMethodInvocation = SPRING_BOOT_APP_CTX_RUNNER_VISITOR.findMethodInvocation((Tree)methodTree);
        if (runMethodInvocation != null) {
            Symbol.TypeSymbol contextConsumerImplSymbol = ((ExpressionTree)runMethodInvocation.arguments().get(0)).symbolType().symbol();
            if (contextConsumerImplSymbol.isUnknown()) {
                return true;
            }
            Type contextConsumerType = contextConsumerImplSymbol.isInterface() ? contextConsumerImplSymbol.type() : (Type)contextConsumerImplSymbol.interfaces().get(0);
            return AssertionsInTestsCheck.isAssertableApplicationContext(contextConsumerType) && this.hasDeclaredAssertions((Symbol)contextConsumerImplSymbol);
        }
        return false;
    }

    private static boolean isAssertableApplicationContext(Type contextConsumerType) {
        return ((Type)contextConsumerType.typeArguments().get(0)).is("org.springframework.boot.test.context.assertj.AssertableApplicationContext");
    }

    private boolean hasDeclaredAssertions(Symbol contextConsumerImplSymbol) {
        Tree declaration = contextConsumerImplSymbol.declaration();
        if (declaration instanceof ClassTreeImpl) {
            ClassTreeImpl contextConsumerImpl = (ClassTreeImpl)declaration;
            return contextConsumerImpl.members().stream().anyMatch(m -> {
                MethodTree method;
                return m instanceof MethodTree && this.isLocalMethodWithAssertion((Symbol)(method = (MethodTree)m).symbol());
            });
        }
        return true;
    }

    private static boolean isSpringBootSanityTest(MethodTree methodTree) {
        if ("contextLoads".equals(methodTree.simpleName().name())) {
            ClassTree classTree = (ClassTree)methodTree.parent();
            return classTree.symbol().metadata().isAnnotatedWith("org.springframework.boot.test.context.SpringBootTest");
        }
        return false;
    }

    private boolean isLocalMethodWithAssertion(Symbol symbol) {
        if (!this.assertionInMethod.containsKey(symbol)) {
            this.assertionInMethod.put(symbol, false);
            Tree declaration = symbol.declaration();
            if (declaration != null) {
                AssertionVisitor assertionVisitor = new AssertionVisitor(this.getCustomAssertionMethodsMatcher());
                declaration.accept((TreeVisitor)assertionVisitor);
                this.assertionInMethod.put(symbol, assertionVisitor.hasAssertion());
            }
        }
        return this.assertionInMethod.get(symbol);
    }

    private MethodMatchers getCustomAssertionMethodsMatcher() {
        if (this.customAssertionMethodsMatcher == null) {
            String[] fullyQualifiedMethodSymbols = this.customAssertionMethods.isEmpty() ? new String[]{} : this.customAssertionMethods.split(",");
            ArrayList<MethodMatchers> customMethodMatchers = new ArrayList<MethodMatchers>(fullyQualifiedMethodSymbols.length);
            for (String fullyQualifiedMethodSymbol : fullyQualifiedMethodSymbols) {
                String[] methodMatcherParts = fullyQualifiedMethodSymbol.split("#");
                if (methodMatcherParts.length == 2 && !StringUtils.isEmpty((CharSequence)methodMatcherParts[0].trim()) && !StringUtils.isEmpty((CharSequence)methodMatcherParts[1].trim())) {
                    String methodName = methodMatcherParts[1].trim();
                    Predicate<String> namePredicate = methodName.endsWith("*") ? name -> name.startsWith(methodName.substring(0, methodName.length() - 1)) : name -> name.equals(methodName);
                    customMethodMatchers.add(MethodMatchers.create().ofSubTypes(new String[]{methodMatcherParts[0].trim()}).name(namePredicate).withAnyParameters().build());
                    continue;
                }
                LOG.warn("Unable to create a corresponding matcher for custom assertion method, please check the format of the following symbol: '{}'", (Object)fullyQualifiedMethodSymbol);
            }
            this.customAssertionMethodsMatcher = MethodMatchers.or(customMethodMatchers);
        }
        return this.customAssertionMethodsMatcher;
    }

    private static boolean expectAssertion(MethodTree methodTree) {
        List annotationValues = methodTree.symbol().metadata().valuesForAnnotation("org.junit.Test");
        if (annotationValues != null) {
            for (SymbolMetadata.AnnotationValue annotationValue : annotationValues) {
                if (!"expected".equals(annotationValue.name())) continue;
                return true;
            }
        }
        return false;
    }

    private static class MethodInvocationMatcherVisitor
    extends BaseTreeVisitor {
        private MethodInvocationTreeImpl methodInvocationTree;
        private final MethodMatchers matcher;

        private MethodInvocationMatcherVisitor(MethodMatchers matcher) {
            this.matcher = matcher;
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (this.matcher.matches(tree)) {
                this.methodInvocationTree = (MethodInvocationTreeImpl)tree;
                return;
            }
            super.visitMethodInvocation(tree);
        }

        public MethodInvocationTreeImpl findMethodInvocation(Tree tree) {
            this.methodInvocationTree = null;
            tree.accept((TreeVisitor)this);
            return this.methodInvocationTree;
        }
    }

    private class AssertionVisitor
    extends AbstractAssertionVisitor {
        private MethodMatchers customMethodsMatcher;

        private AssertionVisitor(MethodMatchers customMethodsMatcher) {
            this.customMethodsMatcher = customMethodsMatcher;
        }

        @Override
        protected boolean isAssertion(Symbol methodSymbol) {
            return this.customMethodsMatcher.matches(methodSymbol) || AssertionsInTestsCheck.this.isLocalMethodWithAssertion(methodSymbol);
        }
    }
}

