/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.checks.helpers.UnresolvedIdentifiersVisitor;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.RecordPatternTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1481")
public class UnusedLocalVariableCheck
extends IssuableSubscriptionVisitor {
    private static final Tree.Kind[] INCREMENT_KINDS = new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT};
    private static final String MESSAGE = "Remove this unused \"%s\" local variable.";
    private static final IdentifierProperties IDENTIFIER_PROPERTIES = new IdentifierProperties();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.COMPILATION_UNIT, Tree.Kind.VARIABLE);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT})) {
            IDENTIFIER_PROPERTIES.check(tree);
        }
    }

    public void leaveNode(Tree tree) {
        boolean unresolved;
        VariableTree variable;
        IdentifierTree simpleName;
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && !(simpleName = (variable = (VariableTree)tree).simpleName()).isUnnamedVariable() && !(unresolved = IDENTIFIER_PROPERTIES.isUnresolved(simpleName.name())) && UnusedLocalVariableCheck.isProperLocalVariable(variable) && UnusedLocalVariableCheck.isUnused(variable.symbol()) && this.canBeReplaced(variable)) {
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)simpleName).withMessage(String.format(MESSAGE, simpleName.name())).withQuickFixes(() -> UnusedLocalVariableCheck.computeQuickFix(variable)).report();
        }
    }

    private boolean canBeReplaced(VariableTree variable) {
        return this.context.getJavaVersion().isJava22Compatible() || !UnusedLocalVariableCheck.isForeachVariable(variable) && !UnusedLocalVariableCheck.isTryResource(variable) && !UnusedLocalVariableCheck.isTypePatternWithinCaseOrRecord(variable);
    }

    private static boolean isUnused(Symbol symbol) {
        return symbol.usages().stream().noneMatch(UnusedLocalVariableCheck::isRValue);
    }

    private static boolean isRValue(IdentifierTree tree) {
        Tree parent = ExpressionUtils.skipParenthesesUpwards((Tree)tree.parent());
        if (parent instanceof AssignmentExpressionTree) {
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)parent;
            return assignment.variable() != tree;
        }
        return !parent.is(INCREMENT_KINDS) || !parent.parent().is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT});
    }

    private static boolean isProperLocalVariable(VariableTree variable) {
        Symbol symbol = variable.symbol();
        return symbol.isLocalVariable() && !symbol.isParameter() && !UnusedLocalVariableCheck.isDefinedInCatchClause(variable);
    }

    private static boolean isDefinedInCatchClause(VariableTree variable) {
        return variable.parent().is(new Tree.Kind[]{Tree.Kind.CATCH});
    }

    private static boolean isTryResource(VariableTree variable) {
        return variable.parent().is(new Tree.Kind[]{Tree.Kind.LIST}) && variable.parent().parent().is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT});
    }

    private static boolean isForeachVariable(VariableTree variable) {
        return variable.parent() instanceof ForEachStatement;
    }

    private static List<JavaQuickFix> computeQuickFix(VariableTree variable) {
        if (UnusedLocalVariableCheck.isForeachVariable(variable) || UnusedLocalVariableCheck.isTryResource(variable) || UnusedLocalVariableCheck.isTypePatternWithinCaseOrRecord(variable)) {
            return List.of(UnusedLocalVariableCheck.makeQuickFixReplacingWithUnnamedVariable(variable));
        }
        return UnusedLocalVariableCheck.getQuickFixTextSpan(variable).map(textSpan -> Collections.singletonList(JavaQuickFix.newQuickFix((String)"Remove unused local variable").addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTextSpan((AnalyzerMessage.TextSpan)textSpan)}).build())).orElseGet(Collections::emptyList);
    }

    private static boolean isTypePatternWithinCaseOrRecord(VariableTree variable) {
        return IDENTIFIER_PROPERTIES.isVariableInsideCase(variable) || IDENTIFIER_PROPERTIES.isVariableInsideRecordPattern(variable);
    }

    private static JavaQuickFix makeQuickFixReplacingWithUnnamedVariable(VariableTree variable) {
        return JavaQuickFix.newQuickFix((String)"Replace unused local variable with _").addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceBetweenTree((Tree)variable.type(), (boolean)true, (Tree)variable.simpleName(), (boolean)true, (String)"var _")}).build();
    }

    private static Optional<AnalyzerMessage.TextSpan> getQuickFixTextSpan(VariableTree variable) {
        if (!variable.symbol().usages().isEmpty()) {
            return Optional.empty();
        }
        Tree parent = variable.parent();
        SyntaxToken lastToken = variable.lastToken();
        if (parent.is(new Tree.Kind[]{Tree.Kind.BLOCK, Tree.Kind.INITIALIZER, Tree.Kind.STATIC_INITIALIZER})) {
            Optional<VariableTree> followingVariable = QuickFixHelper.nextVariable(variable);
            if (followingVariable.isPresent()) {
                return Optional.of(AnalyzerMessage.textSpanBetween((Tree)variable.simpleName(), (boolean)true, (Tree)followingVariable.get().simpleName(), (boolean)false));
            }
            Optional<SyntaxToken> precedingComma = UnusedLocalVariableCheck.getPrecedingComma(variable);
            if (precedingComma.isPresent()) {
                AnalyzerMessage.TextSpan value = AnalyzerMessage.textSpanBetween((Tree)((Tree)precedingComma.get()), (boolean)true, (Tree)lastToken, (boolean)false);
                return Optional.of(value);
            }
            return Optional.of(AnalyzerMessage.textSpanBetween((Tree)variable.firstToken(), (Tree)lastToken));
        }
        if (parent.is(new Tree.Kind[]{Tree.Kind.LIST})) {
            ListTree variables = (ListTree)parent;
            if (variables.size() == 1) {
                return Optional.of(AnalyzerMessage.textSpanFor((Tree)variable));
            }
            if (",".equals(lastToken.text())) {
                return Optional.of(AnalyzerMessage.textSpanBetween((Tree)variable.simpleName(), (Tree)lastToken));
            }
            SyntaxToken precedingComma = ((VariableTree)variables.get(variables.indexOf((Object)variable) - 1)).lastToken();
            return Optional.of(AnalyzerMessage.textSpanBetween((Tree)precedingComma, (Tree)lastToken));
        }
        if (parent.is(new Tree.Kind[]{Tree.Kind.TYPE_PATTERN})) {
            return Optional.of(AnalyzerMessage.textSpanFor((Tree)lastToken));
        }
        return Optional.empty();
    }

    private static Optional<SyntaxToken> getPrecedingComma(VariableTree variable) {
        return QuickFixHelper.previousVariable(variable).map(Tree::lastToken);
    }

    private static class IdentifierProperties
    extends UnresolvedIdentifiersVisitor {
        private final Set<VariableTree> patternVariables = new HashSet<VariableTree>();
        private final Set<VariableTree> caseVariables = new HashSet<VariableTree>();
        private int nestingRecordLevel = 0;
        private boolean withinCaseLabel = false;

        private IdentifierProperties() {
        }

        @Override
        public Set<String> check(Tree tree) {
            this.patternVariables.clear();
            this.caseVariables.clear();
            this.nestingRecordLevel = 0;
            this.withinCaseLabel = false;
            return super.check(tree);
        }

        public boolean isVariableInsideRecordPattern(VariableTree variable) {
            return this.patternVariables.contains(variable);
        }

        public boolean isVariableInsideCase(VariableTree variable) {
            return this.caseVariables.contains(variable);
        }

        public void visitRecordPattern(RecordPatternTree tree) {
            ++this.nestingRecordLevel;
            super.visitRecordPattern(tree);
            --this.nestingRecordLevel;
        }

        public void visitCaseLabel(CaseLabelTree tree) {
            this.withinCaseLabel = true;
            super.visitCaseLabel(tree);
            this.withinCaseLabel = false;
        }

        public void visitVariable(VariableTree tree) {
            if (this.nestingRecordLevel > 0) {
                this.patternVariables.add(tree);
            }
            if (this.withinCaseLabel) {
                this.caseVariables.add(tree);
            }
            super.visitVariable(tree);
        }
    }
}

