/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.collections.SetUtils;

@Rule(key="S2924")
public class UnusedTestRuleCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> CHECKED_RULE = SetUtils.immutableSetOf((Object[])new String[]{"org.junit.rules.TemporaryFolder", "org.junit.rules.TestName"});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        boolean isAbstract = ModifiersUtils.hasModifier((ModifiersTree)classTree.modifiers(), (Modifier)Modifier.ABSTRACT);
        for (Tree member : classTree.members()) {
            if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                VariableTree variableTree = (VariableTree)member;
                Symbol symbol = variableTree.symbol();
                if (!UnusedTestRuleCheck.isTestNameOrTemporaryFolderRule(symbol) && !UnusedTestRuleCheck.hasTempDirAnnotation(symbol) || !symbol.usages().isEmpty() || isAbstract && !ModifiersUtils.hasModifier((ModifiersTree)variableTree.modifiers(), (Modifier)Modifier.PRIVATE)) continue;
                this.reportIssue((Tree)variableTree.simpleName(), "Remove this unused \"" + UnusedTestRuleCheck.getSymbolType(symbol) + "\".");
                continue;
            }
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR})) continue;
            this.checkJUnit5((MethodTree)member);
        }
    }

    private void checkJUnit5(MethodTree member) {
        for (VariableTree param : member.parameters()) {
            Symbol symbol = param.symbol();
            if (!UnusedTestRuleCheck.hasTempDirAnnotation(symbol) && !symbol.type().is("org.junit.jupiter.api.TestInfo") || !symbol.usages().isEmpty()) continue;
            this.reportIssue((Tree)param.simpleName(), "Remove this unused \"" + UnusedTestRuleCheck.getSymbolType(symbol) + "\".");
        }
    }

    private static boolean isTestNameOrTemporaryFolderRule(Symbol symbol) {
        return symbol.metadata().isAnnotatedWith("org.junit.Rule") && CHECKED_RULE.contains(symbol.type().fullyQualifiedName());
    }

    private static boolean hasTempDirAnnotation(Symbol symbol) {
        return symbol.metadata().isAnnotatedWith("org.junit.jupiter.api.io.TempDir");
    }

    private static String getSymbolType(Symbol symbol) {
        return UnusedTestRuleCheck.hasTempDirAnnotation(symbol) ? "TempDir" : symbol.type().toString();
    }
}

