/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import java.util.Set;
import org.sonar.java.filters.AnyRuleIssueFilter;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

public class GeneratedCodeFilter
extends AnyRuleIssueFilter {
    private static final Set<String> GENERATED_ANNOTATIONS = Set.of("javax.annotation.Generated", "javax.annotation.processing.Generated", "jakarta.annotation.Generated", "jakarta.annotation.processing.Generated");

    @Override
    public void scanFile(JavaFileScannerContext context) {
        if (context.getSemanticModel() == null) {
            return;
        }
        super.scanFile(context);
    }

    public void visitClass(ClassTree tree) {
        if (GeneratedCodeFilter.isGenerated((Symbol)tree.symbol())) {
            this.excludeLines((Tree)tree);
        }
        super.visitClass(tree);
    }

    public void visitMethod(MethodTree tree) {
        if (GeneratedCodeFilter.isGenerated((Symbol)tree.symbol())) {
            this.excludeLines((Tree)tree);
        }
        super.visitMethod(tree);
    }

    private static boolean isGenerated(Symbol symbol) {
        return symbol.metadata().annotations().stream().map(SymbolMetadata.AnnotationInstance::symbol).map(Symbol::type).map(Type::fullyQualifiedName).anyMatch(GENERATED_ANNOTATIONS::contains);
    }
}

