/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6898")
public class AvoidHighFrameratesOnMobileCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_THRESHOLD = 60;
    private static final Map<MethodMatchers, Integer> FRAME_RATE_SETTERS = Map.of(MethodMatchers.create().ofTypes(new String[]{"android.view.Surface"}).names(new String[]{"setFrameRate"}).withAnyParameters().build(), 0, MethodMatchers.create().ofTypes(new String[]{"android.view.SurfaceControl"}).names(new String[]{"setFrameRate"}).withAnyParameters().build(), 1);

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        FRAME_RATE_SETTERS.entrySet().stream().filter(e -> ((MethodMatchers)e.getKey()).matches(mit)).findFirst().ifPresent(e -> {
            Number frameRateNumber;
            ExpressionTree frameRateArg = (ExpressionTree)mit.arguments().get(((Integer)e.getValue()).intValue());
            Object frameRateArgVal = ExpressionUtils.resolveAsConstant((ExpressionTree)frameRateArg);
            if (frameRateArgVal instanceof Number && (frameRateNumber = (Number)frameRateArgVal).intValue() > 60) {
                this.reportIssue((Tree)frameRateArg, "Avoid setting high frame rates higher than 60 on mobile devices.");
            }
        });
    }
}

