/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3306")
public class ConstructorInjectionCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        List members = ((ClassTree)tree).members();
        Optional<Tree> first = members.stream().filter(t -> t.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) && ConstructorInjectionCheck.isPrivateConstructor((MethodTree)t)).findFirst();
        if (first.isPresent()) {
            return;
        }
        members.stream().filter(t -> t.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && ConstructorInjectionCheck.isAnnotatedWithInject((VariableTree)t)).forEach(field -> this.reportIssue((Tree)((VariableTree)field).simpleName(), "Use constructor injection for this field."));
    }

    private static boolean isPrivateConstructor(MethodTree constructor) {
        return constructor.symbol().isPrivate();
    }

    private static boolean isAnnotatedWithInject(VariableTree field) {
        return field.symbol().metadata().isAnnotatedWith("javax.inject.Inject");
    }
}

